/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyNetwork;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.GlobalAppearance;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.parsers.ColorParser;
import cytoscape.visual.parsers.ObjectToString;
import java.awt.Color;
import java.util.Properties;

public class GlobalAppearanceCalculator
extends SubjectBase
implements Cloneable {
    Color defaultBackgroundColor = Color.WHITE;
    Color defaultSloppySelectionColor = Color.GRAY;
    private Color defaultNodeSelectionColor = Color.YELLOW;
    private Color defaultNodeReverseSelectionColor = Color.GREEN;
    private Color defaultEdgeSelectionColor = Color.RED;
    private Color defaultEdgeReverseSelectionColor = Color.GREEN;

    public Object clone() throws CloneNotSupportedException {
        Object copy = null;
        copy = super.clone();
        return copy;
    }

    public GlobalAppearanceCalculator() {
    }

    public GlobalAppearanceCalculator(GlobalAppearanceCalculator toCopy) {
        if (toCopy == null) {
            return;
        }
        this.setDefaultBackgroundColor(toCopy.getDefaultBackgroundColor());
        this.setDefaultSloppySelectionColor(toCopy.getDefaultSloppySelectionColor());
        this.setDefaultNodeSelectionColor(toCopy.getDefaultNodeSelectionColor());
        this.setDefaultNodeReverseSelectionColor(toCopy.getDefaultNodeReverseSelectionColor());
        this.setDefaultEdgeSelectionColor(toCopy.getDefaultEdgeSelectionColor());
        this.setDefaultEdgeReverseSelectionColor(toCopy.getDefaultEdgeReverseSelectionColor());
    }

    public GlobalAppearanceCalculator(String name, Properties gProps, String baseKey, CalculatorCatalog catalog) {
        this.applyProperties(name, gProps, baseKey, catalog);
    }

    public GlobalAppearance calculateGlobalAppearance(CyNetwork network) {
        GlobalAppearance appr = new GlobalAppearance();
        this.calculateGlobalAppearance(appr, network);
        return appr;
    }

    public void calculateGlobalAppearance(GlobalAppearance appr, CyNetwork network) {
        appr.setBackgroundColor(this.calculateBackgroundColor(network));
        appr.setSloppySelectionColor(this.calculateSloppySelectionColor(network));
        appr.setNodeSelectionColor(this.calculateNodeSelectionColor(network));
        appr.setNodeReverseSelectionColor(this.calculateNodeReverseSelectionColor(network));
        appr.setEdgeSelectionColor(this.calculateEdgeSelectionColor(network));
        appr.setEdgeReverseSelectionColor(this.calculateEdgeReverseSelectionColor(network));
    }

    public Color getDefaultBackgroundColor() {
        return this.defaultBackgroundColor;
    }

    public void setDefaultBackgroundColor(Color c) {
        if (c != null) {
            this.defaultBackgroundColor = c;
            this.fireStateChanged();
        }
    }

    public Color calculateBackgroundColor(CyNetwork network) {
        return this.defaultBackgroundColor;
    }

    public Color getDefaultSloppySelectionColor() {
        return this.defaultSloppySelectionColor;
    }

    public void setDefaultSloppySelectionColor(Color c) {
        if (c != null) {
            this.fireStateChanged();
            this.defaultSloppySelectionColor = c;
        }
    }

    public Color getDefaultNodeSelectionColor() {
        return this.defaultNodeSelectionColor;
    }

    public void setDefaultNodeSelectionColor(Color c) {
        if (c != null) {
            this.defaultNodeSelectionColor = c;
            this.fireStateChanged();
        }
    }

    public Color getDefaultNodeReverseSelectionColor() {
        return this.defaultNodeReverseSelectionColor;
    }

    public void setDefaultNodeReverseSelectionColor(Color c) {
        if (c != null) {
            this.defaultNodeReverseSelectionColor = c;
            this.fireStateChanged();
        }
    }

    public Color getDefaultEdgeSelectionColor() {
        return this.defaultEdgeSelectionColor;
    }

    public void setDefaultEdgeSelectionColor(Color c) {
        if (c != null) {
            this.defaultEdgeSelectionColor = c;
            this.fireStateChanged();
        }
    }

    public Color getDefaultEdgeReverseSelectionColor() {
        return this.defaultEdgeReverseSelectionColor;
    }

    public void setDefaultEdgeReverseSelectionColor(Color c) {
        if (c != null) {
            this.defaultEdgeReverseSelectionColor = c;
            this.fireStateChanged();
        }
    }

    public Color calculateSloppySelectionColor(CyNetwork network) {
        return this.defaultSloppySelectionColor;
    }

    public Color calculateNodeSelectionColor(CyNetwork network) {
        return this.defaultNodeSelectionColor;
    }

    public Color calculateNodeReverseSelectionColor(CyNetwork network) {
        return this.defaultNodeReverseSelectionColor;
    }

    public Color calculateEdgeSelectionColor(CyNetwork network) {
        return this.defaultEdgeSelectionColor;
    }

    public Color calculateEdgeReverseSelectionColor(CyNetwork network) {
        return this.defaultEdgeReverseSelectionColor;
    }

    public String getDescription() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append("GlobalAppearanceCalculator:" + lineSep);
        sb.append("defaultBackgroundColor = ");
        sb.append(this.defaultBackgroundColor).append(lineSep);
        sb.append("defaultSloppySelectionColor = ");
        sb.append(this.defaultSloppySelectionColor).append(lineSep);
        return sb.toString();
    }

    public void applyProperties(String name, Properties nacProps, String baseKey, CalculatorCatalog catalog) {
        Color c;
        String value = null;
        value = nacProps.getProperty(baseKey + ".defaultBackgroundColor");
        if (value != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultBackgroundColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultSloppySelectionColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultSloppySelectionColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeSelectionColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultNodeSelectionColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultNodeReverseSelectionColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultNodeReverseSelectionColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultEdgeSelectionColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultEdgeSelectionColor(c);
        }
        if ((value = nacProps.getProperty(baseKey + ".defaultEdgeReverseSelectionColor")) != null && (c = new ColorParser().parseColor(value)) != null) {
            this.setDefaultEdgeReverseSelectionColor(c);
        }
    }

    public Properties getProperties(String baseKey) {
        String key = null;
        String value = null;
        Properties newProps = new Properties();
        key = baseKey + ".defaultBackgroundColor";
        value = ObjectToString.getStringValue(this.getDefaultBackgroundColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultSloppySelectionColor";
        value = ObjectToString.getStringValue(this.getDefaultSloppySelectionColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeSelectionColor";
        value = ObjectToString.getStringValue(this.getDefaultNodeSelectionColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultNodeReverseSelectionColor";
        value = ObjectToString.getStringValue(this.getDefaultNodeReverseSelectionColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeSelectionColor";
        value = ObjectToString.getStringValue(this.getDefaultEdgeSelectionColor());
        newProps.setProperty(key, value);
        key = baseKey + ".defaultEdgeReverseSelectionColor";
        value = ObjectToString.getStringValue(this.getDefaultEdgeReverseSelectionColor());
        newProps.setProperty(key, value);
        return newProps;
    }
}

