/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.task;

import csplugins.dataviewer.mapper.MapPsiInteractionsToGraph;
import csplugins.dataviewer.ui.ErrorDisplay;
import csplugins.task.BaseTask;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.mskcc.dataservices.live.interaction.ReadPsiFromFileOrWeb;

public class LoadPsiTask
extends BaseTask {
    private URL url;
    private File file;
    private String networkTitle;
    private Component parentFrame;
    private static final String TASK_TITLE = "Retrieving PSI-MI File";

    public LoadPsiTask(URL uRL) {
        super(TASK_TITLE);
        this.url = uRL;
    }

    public LoadPsiTask(File file) {
        super(TASK_TITLE);
        this.file = file;
    }

    public void setParentFrame(Component component) {
        this.parentFrame = component;
    }

    public void executeTask() throws Exception {
        try {
            ReadPsiFromFileOrWeb readPsiFromFileOrWeb = new ReadPsiFromFileOrWeb();
            ArrayList arrayList = null;
            this.setIndeterminate(true);
            this.setProgressMessage("Retrieving PSI-MI File...");
            if (this.file != null) {
                arrayList = readPsiFromFileOrWeb.getInteractionsFromUrl(this.file.toString());
                this.networkTitle = this.file.getName();
            } else {
                arrayList = readPsiFromFileOrWeb.getInteractionsFromUrl(this.url.toString());
                this.networkTitle = "PSI-MI From Web";
            }
            this.setProgressMessage("Mapping to Cytoscape Network.  Please wait..");
            CyNetwork cyNetwork = Cytoscape.createNetwork((String)this.networkTitle);
            cyNetwork.setTitle(this.networkTitle);
            CyNetworkView cyNetworkView = Cytoscape.createNetworkView((CyNetwork)cyNetwork);
            Cytoscape.destroyNetworkView((CyNetworkView)cyNetworkView);
            MapPsiInteractionsToGraph mapPsiInteractionsToGraph = new MapPsiInteractionsToGraph(arrayList, cyNetwork, 2);
            mapPsiInteractionsToGraph.setBaseTask(this);
            mapPsiInteractionsToGraph.doMapping();
            StringBuffer stringBuffer = new StringBuffer("Loaded PSI-MI File with a total of: " + arrayList.size() + " interactions.\n");
            if (cyNetwork.getNodeCount() < Cytoscape.getCytoscapeObj().getViewThreshold()) {
                stringBuffer.append("\nYour Network is Under " + Cytoscape.getCytoscapeObj().getViewThreshold() + " nodes --> a Cytoscape View  will be " + "automatically created.");
                this.setProgressMessage("Creating Network View.  Please wait.");
                CyNetworkView cyNetworkView2 = Cytoscape.createNetworkView((CyNetwork)cyNetwork);
                this.setProgressMessage("Applying Visual Styles.");
                Cytoscape.getDesktop().getVizMapManager().applyAppearances();
            } else {
                stringBuffer.append("\nYour Network is Over " + Cytoscape.getCytoscapeObj().getViewThreshold() + " nodes --> a Cytoscape View  will not be " + "automatically created.");
            }
            this.updateUser(stringBuffer.toString());
        }
        catch (Exception exception) {
            this.showError(exception);
            throw exception;
        }
    }

    private void updateUser(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(LoadPsiTask.this.parentFrame, string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void showError(final Throwable throwable) {
        Runnable runnable = new Runnable(){

            public void run() {
                ErrorDisplay errorDisplay = new ErrorDisplay((JFrame)LoadPsiTask.this.parentFrame);
                errorDisplay.displayError(throwable);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

