/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.cache;

import java.util.HashMap;
import org.mskcc.dataservices.cache.Cacheable;
import org.mskcc.dataservices.cache.CachedObject;

public class CacheManager {
    private HashMap cache = new HashMap();
    private static CacheManager cacheManager;

    private CacheManager() {
    }

    public static CacheManager getInstance() {
        if (cacheManager == null) {
            cacheManager = new CacheManager();
        }
        return cacheManager;
    }

    public int size() {
        return this.cache.size();
    }

    public synchronized void putCache(String string, Object object, int n) {
        if (this.cache.size() > 1000) {
            this.clearCache();
        }
        CachedObject cachedObject = new CachedObject(object, n);
        this.cache.put(string, cachedObject);
    }

    public Object getCache(String string) {
        Cacheable cacheable = (Cacheable)this.cache.get(string);
        if (cacheable == null) {
            return null;
        }
        if (cacheable.isExpired()) {
            this.cache.remove(string);
            return null;
        }
        return cacheable.getValue();
    }

    public void clearCache() {
        this.cache = new HashMap();
    }

    public HashMap getEntireCache() {
        return this.cache;
    }
}

