/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.live.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mskcc.dataservices.bio.Matrix;
import org.mskcc.dataservices.bio.StateInformation;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.live.DataServiceBase;
import org.mskcc.dataservices.services.ReadStateInformation;
import org.mskcc.dataservices.util.ContentReader;
import org.mskcc.dataservices.util.StringParser;

public class ReadExpressionFromFileOrWeb
extends DataServiceBase
implements ReadStateInformation {
    private StateInformation stateInfo;

    public StateInformation getStateInformation(String string) throws DataServiceException {
        try {
            ContentReader contentReader = new ContentReader();
            String string2 = contentReader.retrieveContent(string);
            this.parseFile(string2);
        }
        catch (IOException iOException) {
            String string3 = "Error Occurred while parsing the Gene Expression Data File.  Please try again.";
            throw new DataServiceException(iOException, string3);
        }
        return this.stateInfo;
    }

    private void parseFile(String string) throws IOException {
        int n;
        this.stateInfo = new StateInformation();
        ArrayList arrayList = StringParser.createArrayList(string);
        arrayList = this.normalizeWithTabs(arrayList);
        int n2 = 0;
        String string2 = (String)arrayList.get(n2);
        while (string2.startsWith("#")) {
            string2 = (String)arrayList.get(++n2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            arrayList2.add(string3);
        }
        for (n = 0; n <= n2; ++n) {
            arrayList.remove(0);
        }
        n = StringParser.countColumns(arrayList);
        Matrix matrix = new Matrix(arrayList.size(), n);
        matrix.setHeaderNames(arrayList2);
        StringParser.parseIntoMatrix(matrix, arrayList);
        this.stateInfo.addMatrix(matrix);
    }

    private ArrayList normalizeWithTabs(ArrayList arrayList) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = (String)arrayList.get(i);
            String[] stringArray = string.split("\\s+");
            for (int j = 0; j < stringArray.length; ++j) {
                stringBuffer.append(stringArray[j] + "\t");
            }
            arrayList2.add(stringBuffer.toString());
        }
        return arrayList2;
    }
}

