/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.mapper;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.jdom.Text;
import org.mskcc.dataservices.bio.ExternalReference;
import org.mskcc.dataservices.bio.Interaction;
import org.mskcc.dataservices.bio.Interactor;
import org.mskcc.dataservices.mapper.Mapper;
import org.mskcc.dataservices.mapper.MapperException;
import org.mskcc.dataservices.mapper.MapperUtil;
import org.mskcc.dataservices.schemas.psi.BibrefType;
import org.mskcc.dataservices.schemas.psi.CvType;
import org.mskcc.dataservices.schemas.psi.DbReferenceType;
import org.mskcc.dataservices.schemas.psi.Entry;
import org.mskcc.dataservices.schemas.psi.EntrySet;
import org.mskcc.dataservices.schemas.psi.ExperimentList;
import org.mskcc.dataservices.schemas.psi.ExperimentList1;
import org.mskcc.dataservices.schemas.psi.ExperimentListItem;
import org.mskcc.dataservices.schemas.psi.ExperimentType;
import org.mskcc.dataservices.schemas.psi.InteractionElementType;
import org.mskcc.dataservices.schemas.psi.InteractionList;
import org.mskcc.dataservices.schemas.psi.InteractorList;
import org.mskcc.dataservices.schemas.psi.NamesType;
import org.mskcc.dataservices.schemas.psi.Organism;
import org.mskcc.dataservices.schemas.psi.ParticipantList;
import org.mskcc.dataservices.schemas.psi.ProteinInteractorType;
import org.mskcc.dataservices.schemas.psi.ProteinParticipantType;
import org.mskcc.dataservices.schemas.psi.ProteinParticipantTypeChoice;
import org.mskcc.dataservices.schemas.psi.RefType;
import org.mskcc.dataservices.schemas.psi.XrefType;
import org.mskcc.dataservices.schemas.psi.types.RoleType;

public class MapPsiToInteractions
implements Mapper {
    private HashMap interactorMap;
    private HashMap experimentMap;
    private ArrayList interactions;
    private String xml;

    public MapPsiToInteractions(String string, ArrayList arrayList) {
        this.xml = string;
        this.interactions = arrayList;
    }

    public void doMapping() throws MapperException {
        this.parseXml(this.xml);
    }

    private void parseXml(String string) throws MapperException {
        try {
            this.interactorMap = new HashMap();
            this.experimentMap = new HashMap();
            StringReader stringReader = new StringReader(string);
            EntrySet entrySet = EntrySet.unmarshalEntrySet(stringReader);
            int n = entrySet.getEntryCount();
            for (int i = 0; i < n; ++i) {
                Entry entry = entrySet.getEntry(i);
                this.extractEntry(entry);
            }
        }
        catch (ValidationException validationException) {
            throw new MapperException(validationException, "PSI-MI XML File is invalid:  " + validationException.getMessage());
        }
        catch (MarshalException marshalException) {
            throw new MapperException(marshalException, "PSI-MI XML File is invalid:  " + marshalException.getMessage());
        }
    }

    private void extractEntry(Entry entry) throws MapperException {
        ExperimentList1 experimentList1 = entry.getExperimentList1();
        this.extractExperimentList(experimentList1);
        InteractorList interactorList = entry.getInteractorList();
        this.extractInteractorList(interactorList);
        InteractionList interactionList = entry.getInteractionList();
        this.extractInteractionList(interactionList);
    }

    private void extractExperimentList(ExperimentList1 experimentList1) {
        if (experimentList1 != null) {
            int n = experimentList1.getExperimentDescriptionCount();
            for (int i = 0; i < n; ++i) {
                ExperimentType experimentType = experimentList1.getExperimentDescription(i);
                String string = experimentType.getId();
                this.experimentMap.put(string, experimentType);
            }
        }
    }

    private void extractInteractorList(InteractorList interactorList) {
        if (interactorList != null) {
            int n = interactorList.getProteinInteractorCount();
            for (int i = 0; i < n; ++i) {
                ProteinInteractorType proteinInteractorType = interactorList.getProteinInteractor(i);
                String string = proteinInteractorType.getId();
                this.interactorMap.put(string, proteinInteractorType);
            }
        }
    }

    private void extractInteractionList(InteractionList interactionList) throws MapperException {
        int n = interactionList.getInteractionCount();
        for (int i = 0; i < n; ++i) {
            Interaction interaction = new Interaction();
            InteractionElementType interactionElementType = interactionList.getInteraction(i);
            ParticipantList participantList = interactionElementType.getParticipantList();
            int n2 = participantList.getProteinParticipantCount();
            ArrayList<Interactor> arrayList = new ArrayList<Interactor>();
            HashMap<String, RoleType> hashMap = new HashMap<String, RoleType>();
            for (int j = 0; j < n2; ++j) {
                Interactor interactor = this.extractInteractorRefOrElement(participantList, j);
                arrayList.add(interactor);
                ProteinParticipantType proteinParticipantType = participantList.getProteinParticipant(j);
                RoleType roleType = proteinParticipantType.getRole();
                if (roleType == null) continue;
                hashMap.put(interactor.getName(), roleType);
            }
            interaction.setInteractors(arrayList);
            ArrayList arrayList2 = this.extractExperimentalData(interactionElementType, interaction);
            for (int j = 0; j < arrayList2.size(); ++j) {
                interaction = (Interaction)arrayList2.get(j);
                interaction.addAttribute("BAIT_MAP", hashMap);
                this.extractInteractionNamesXrefs(interactionElementType, interaction);
            }
            this.interactions.addAll(arrayList2);
        }
    }

    private void extractInteractionNamesXrefs(InteractionElementType interactionElementType, Interaction interaction) {
        ExternalReference[] externalReferenceArray;
        Object object;
        NamesType namesType = interactionElementType.getNames();
        if (namesType != null) {
            object = namesType.getShortLabel();
            externalReferenceArray = namesType.getFullName();
            if (object != null) {
                interaction.addAttribute("INTERACTION_SHORT_NAME", object);
            }
            if (externalReferenceArray != null) {
                interaction.addAttribute("INTERACTION_FULL_NAME", externalReferenceArray);
            }
        }
        if ((externalReferenceArray = this.extractExternalRefs((XrefType)(object = interactionElementType.getXref()))) != null && externalReferenceArray.length > 0) {
            interaction.setExternalRefs(externalReferenceArray);
        }
    }

    private Interactor extractInteractorRefOrElement(ParticipantList participantList, int n) throws MapperException {
        ProteinInteractorType proteinInteractorType;
        Interactor interactor = null;
        ProteinParticipantType proteinParticipantType = participantList.getProteinParticipant(n);
        ProteinParticipantTypeChoice proteinParticipantTypeChoice = proteinParticipantType.getProteinParticipantTypeChoice();
        RefType refType = proteinParticipantTypeChoice.getProteinInteractorRef();
        if (refType != null) {
            String string = refType.getRef();
            proteinInteractorType = (ProteinInteractorType)this.interactorMap.get(string);
            if (proteinInteractorType == null) {
                throw new MapperException("No Interactor Found for proteinInteractorRef:  " + string);
            }
        } else {
            proteinInteractorType = proteinParticipantTypeChoice.getProteinInteractor();
        }
        if (proteinInteractorType != null) {
            interactor = this.createInteractor(proteinInteractorType);
        }
        return interactor;
    }

    private void extractInteractorName(ProteinInteractorType proteinInteractorType, Interactor interactor) throws MapperException {
        NamesType namesType = proteinInteractorType.getNames();
        if (namesType != null) {
            String string = MapperUtil.extractName(proteinInteractorType, interactor.getExternalRefs());
            Text text = new Text(string);
            string = text.getTextNormalize();
            interactor.setName(string);
            String string2 = namesType.getFullName();
            interactor.addAttribute("FULL_NAME", string2);
        }
    }

    private ExternalReference[] extractExternalRefs(XrefType xrefType) {
        ArrayList arrayList = new ArrayList();
        if (xrefType != null) {
            DbReferenceType dbReferenceType = xrefType.getPrimaryRef();
            this.createExternalReference(dbReferenceType.getDb(), dbReferenceType.getId(), arrayList);
            int n = xrefType.getSecondaryRefCount();
            for (int i = 0; i < n; ++i) {
                DbReferenceType dbReferenceType2 = xrefType.getSecondaryRef(i);
                this.createExternalReference(dbReferenceType2.getDb(), dbReferenceType2.getId(), arrayList);
            }
            ExternalReference[] externalReferenceArray = new ExternalReference[arrayList.size()];
            externalReferenceArray = arrayList.toArray(externalReferenceArray);
            return externalReferenceArray;
        }
        return null;
    }

    private void createExternalReference(String string, String string2, ArrayList arrayList) {
        ExternalReference externalReference = new ExternalReference(string, string2);
        arrayList.add(externalReference);
    }

    private ArrayList extractExperimentalData(InteractionElementType interactionElementType, Interaction interaction) throws MapperException {
        ExperimentList experimentList = interactionElementType.getExperimentList();
        ArrayList<Interaction> arrayList = new ArrayList<Interaction>();
        if (experimentList != null) {
            int n = experimentList.getExperimentListItemCount();
            for (int i = 0; i < n; ++i) {
                Interaction interaction2 = this.cloneInteractionTemplate(interaction);
                ExperimentListItem experimentListItem = experimentList.getExperimentListItem(i);
                ExperimentType experimentType = this.extractExperimentReferenceOrElement(experimentListItem);
                String string = this.getPubMedId(experimentType);
                if (string != null) {
                    interaction2.addAttribute("PUB_MED_ID", string);
                }
                this.extractInteractionDetection(experimentType, interaction2);
                arrayList.add(interaction2);
            }
        } else {
            throw new MapperException("Could not determine experimental data for one of the PSI-MI interactions");
        }
        return arrayList;
    }

    private Interaction cloneInteractionTemplate(Interaction interaction) {
        Interaction interaction2 = new Interaction();
        ArrayList arrayList = interaction.getInteractors();
        interaction2.setInteractors(arrayList);
        return interaction2;
    }

    private ExperimentType extractExperimentReferenceOrElement(ExperimentListItem experimentListItem) {
        ExperimentType experimentType = null;
        RefType refType = experimentListItem.getExperimentRef();
        if (refType != null) {
            String string = refType.getRef();
            experimentType = (ExperimentType)this.experimentMap.get(string);
        } else {
            experimentType = experimentListItem.getExperimentDescription();
        }
        return experimentType;
    }

    private void extractInteractionDetection(ExperimentType experimentType, Interaction interaction) {
        String string = null;
        if (experimentType != null) {
            DbReferenceType dbReferenceType;
            XrefType xrefType;
            CvType cvType = experimentType.getInteractionDetection();
            NamesType namesType = cvType.getNames();
            string = namesType.getShortLabel();
            if (string != null) {
                interaction.addAttribute("EXPERIMENTAL_SYSTEM_NAME", string);
            }
            if ((xrefType = cvType.getXref()) != null && (dbReferenceType = xrefType.getPrimaryRef()) != null) {
                interaction.addAttribute("EXPERIMENTAL_SYSTEM_XREF_DB", dbReferenceType.getDb());
                interaction.addAttribute("EXPERIMENTAL_SYSTEM_XREF_ID", dbReferenceType.getId());
            }
        }
    }

    private String getPubMedId(ExperimentType experimentType) {
        DbReferenceType dbReferenceType;
        XrefType xrefType;
        BibrefType bibrefType;
        String string = null;
        if (experimentType != null && (bibrefType = experimentType.getBibref()) != null && (xrefType = bibrefType.getXref()) != null && (dbReferenceType = xrefType.getPrimaryRef()) != null) {
            string = dbReferenceType.getId();
        }
        return string;
    }

    private Interactor createInteractor(ProteinInteractorType proteinInteractorType) throws MapperException {
        Interactor interactor = new Interactor();
        this.extractOrganismInfo(proteinInteractorType, interactor);
        this.extractSequenceData(proteinInteractorType, interactor);
        ExternalReference[] externalReferenceArray = this.extractExternalRefs(proteinInteractorType.getXref());
        if (externalReferenceArray != null && externalReferenceArray.length > 0) {
            interactor.setExternalRefs(externalReferenceArray);
        }
        String string = proteinInteractorType.getId();
        interactor.addAttribute("LOCAL_ID", string);
        this.extractInteractorName(proteinInteractorType, interactor);
        return interactor;
    }

    private void extractSequenceData(ProteinInteractorType proteinInteractorType, Interactor interactor) {
        String string = proteinInteractorType.getSequence();
        if (string != null) {
            interactor.addAttribute("SEQUENCE_DATA", string);
        }
    }

    private void extractOrganismInfo(ProteinInteractorType proteinInteractorType, Interactor interactor) {
        Organism organism = proteinInteractorType.getOrganism();
        if (organism != null) {
            NamesType namesType = organism.getNames();
            String string = namesType.getShortLabel();
            String string2 = namesType.getFullName();
            int n = organism.getNcbiTaxId();
            interactor.addAttribute("ORGANISM_COMMON_NAME", string);
            interactor.addAttribute("ORGANISM_SPECIES", string2);
            interactor.addAttribute("ORGANISM_NCBI_TAXON_ID", Integer.toString(n));
        }
    }
}

