/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.action;

import csplugins.dataviewer.model.OrganismOption;
import csplugins.dataviewer.model.SearchBundleList;
import csplugins.dataviewer.model.SearchRequest;
import csplugins.dataviewer.task.QueryCPathTask;
import csplugins.dataviewer.ui.Console;
import csplugins.task.ui.TaskMonitorUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class ExecuteQuery
extends KeyAdapter
implements ActionListener {
    private HashMap cyMap;
    private SearchRequest searchRequest;
    private JFrame parent;
    private QueryCPathTask task;
    private SearchBundleList searchBundleList;
    private JButton searchButton;
    private Console console;

    public ExecuteQuery(HashMap hashMap, SearchRequest searchRequest, SearchBundleList searchBundleList, Console console, JButton jButton, JFrame jFrame) {
        this.cyMap = hashMap;
        this.searchRequest = searchRequest;
        this.parent = jFrame;
        this.searchBundleList = searchBundleList;
        this.searchButton = jButton;
        this.console = console;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.executeQuery();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            JTextField jTextField = (JTextField)keyEvent.getSource();
            this.searchRequest.setQuery(jTextField.getText());
            this.executeQuery();
        }
    }

    private void executeQuery() {
        if (this.searchRequest.getQuery().length() == 0 && this.searchRequest.getOrganism().equals(OrganismOption.ALL_ORGANISMS)) {
            JOptionPane.showMessageDialog(this.parent, "Please Specify a Keyword and/or an Organism, and try again.", "cPath PlugIn", 1);
        } else {
            this.searchButton.setEnabled(false);
            this.console.clear();
            this.task = new QueryCPathTask(this.cyMap, this.searchRequest, this.searchBundleList, this.console);
            new TaskMonitorUI(this.task, true, true, true, 0, this.parent);
            this.task.start();
        }
    }
}

