/*
 * Decompiled with CFR 0.152.
 */
package csplugins.task;

import csplugins.task.Task;
import java.util.Date;

public abstract class BaseTask
extends Thread
implements Task {
    private boolean taskIsDone = false;
    private boolean indeterminate = true;
    private int progressValue = 0;
    private int maxProgressValue = Integer.MAX_VALUE;
    private String progressMessage = "Starting...";
    private String humanErrorMessage;
    private long estimatedTimeRemaining = -1L;
    private Throwable internalException;
    private boolean interruptFlag = false;
    private boolean errorFlag = false;
    private String taskTitle;
    private Date startTime;
    private Date stopTime;

    public BaseTask(String string) {
        this.taskTitle = string;
        this.startTime = new Date();
    }

    public String getTaskTitle() {
        return this.taskTitle;
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public boolean isDone() {
        return this.taskIsDone;
    }

    public int getProgressValue() {
        return this.progressValue;
    }

    public int getMaxProgressValue() {
        return this.maxProgressValue;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    public long getEstimatedTimeRemaining() {
        return this.estimatedTimeRemaining;
    }

    public long getTimeElapsed() {
        if (this.stopTime != null) {
            return this.stopTime.getTime() - this.startTime.getTime();
        }
        Date date = new Date();
        return date.getTime() - this.startTime.getTime();
    }

    public boolean errorOccurred() {
        return this.errorFlag;
    }

    public String getHumanReadableErrorMessage() {
        return this.humanErrorMessage;
    }

    public Throwable getInternalException() {
        return this.internalException;
    }

    public void interrupt() {
        this.interruptFlag = true;
        super.interrupt();
    }

    public boolean isInterrupted() {
        return this.interruptFlag;
    }

    public void setDone() {
        this.taskIsDone = true;
    }

    public void setIndeterminate(boolean bl) {
        this.indeterminate = bl;
    }

    public void setProgressValue(int n) {
        this.progressValue = n;
        this.setIndeterminate(false);
    }

    public void setMaxProgressValue(int n) {
        this.maxProgressValue = n;
        this.setIndeterminate(false);
    }

    public void setProgressMessage(String string) {
        this.progressMessage = string;
    }

    public void setTaskTitle(String string) {
        this.taskTitle = string;
    }

    public void setEstimatedTimeRemaining(long l) {
        this.estimatedTimeRemaining = l;
    }

    public void setErrorOccured(boolean bl) {
        this.errorFlag = bl;
    }

    public void setHumanReadableErrorMessage(String string) {
        this.humanErrorMessage = string;
    }

    public void setException(Throwable throwable) {
        this.internalException = throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            this.executeTask();
        }
        catch (Throwable throwable) {
            this.setErrorOccured(true);
            this.setException(throwable);
        }
        finally {
            this.stopTime = new Date();
            this.setDone();
        }
    }

    public abstract void executeTask() throws Exception;
}

