/*
 * Decompiled with CFR 0.152.
 */
package csplugins.test.mapper;

import csplugins.dataviewer.mapper.MapInteractionsToGraph;
import csplugins.dataviewer.mapper.MapPsiInteractionsToGraph;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import giny.model.Edge;
import giny.model.Node;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.mskcc.dataservices.bio.vocab.CommonVocab;
import org.mskcc.dataservices.mapper.MapPsiToInteractions;
import org.mskcc.dataservices.util.ContentReader;

public class TestMapInteractionsToGraph
extends TestCase {
    public void testMapper1() throws Exception {
        ArrayList arrayList = new ArrayList();
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent("testData/psi_sample1.xml");
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        CyNetwork cyNetwork = Cytoscape.createNetwork((String)"network1");
        MapPsiInteractionsToGraph mapPsiInteractionsToGraph = new MapPsiInteractionsToGraph(arrayList, cyNetwork, 2);
        mapPsiInteractionsToGraph.doMapping();
        int n = cyNetwork.getNodeCount();
        int n2 = cyNetwork.getEdgeCount();
        TestMapInteractionsToGraph.assertEquals((int)7, (int)n);
        TestMapInteractionsToGraph.assertEquals((int)6, (int)n2);
        List list = cyNetwork.nodesList();
        List list2 = cyNetwork.edgesList();
        CyNode cyNode = (CyNode)list.get(0);
        String string2 = cyNode.getIdentifier();
        TestMapInteractionsToGraph.assertEquals((String)"YDL065C", (String)string2);
        CyEdge cyEdge = (CyEdge)list2.get(0);
        String string3 = cyEdge.getIdentifier();
        TestMapInteractionsToGraph.assertEquals((String)"YCR038C (classical two hybrid, pmid:  11283351) YDR532C", (String)string3);
        CyNode cyNode2 = cyEdge.getSourceNode();
        CyNode cyNode3 = cyEdge.getTargetNode();
        TestMapInteractionsToGraph.assertEquals((String)"YCR038C", (String)cyNode2.getIdentifier());
        TestMapInteractionsToGraph.assertEquals((String)"YDR532C", (String)cyNode3.getIdentifier());
        String string4 = (String)cyNetwork.getNodeAttributeValue((Node)cyNode2, "ORGANISM_NCBI_TAXON_ID");
        TestMapInteractionsToGraph.assertEquals((String)"4932", (String)string4);
        String string5 = (String)cyNetwork.getNodeAttributeValue((Node)cyNode2, "FULL_NAME");
        TestMapInteractionsToGraph.assertTrue((string5.indexOf("GTP/GDP exchange factor") > -1 ? 1 : 0) != 0);
        String[] stringArray = (String[])cyNetwork.getNodeAttributeValue((Node)cyNode2, CommonVocab.XREF_DB_NAME);
        TestMapInteractionsToGraph.assertEquals((int)15, (int)stringArray.length);
        TestMapInteractionsToGraph.assertEquals((String)"RefSeq GI", (String)stringArray[0]);
        stringArray = (String[])cyNetwork.getEdgeAttributeValue((Edge)cyEdge, CommonVocab.XREF_DB_NAME);
        String[] stringArray2 = (String[])cyNetwork.getEdgeAttributeValue((Edge)cyEdge, CommonVocab.XREF_DB_ID);
        TestMapInteractionsToGraph.assertEquals((int)2, (int)stringArray.length);
        TestMapInteractionsToGraph.assertEquals((int)2, (int)stringArray2.length);
        TestMapInteractionsToGraph.assertEquals((String)"DIP", (String)stringArray[0]);
        TestMapInteractionsToGraph.assertEquals((String)"CPATH", (String)stringArray[1]);
        TestMapInteractionsToGraph.assertEquals((String)"61E", (String)stringArray2[0]);
        TestMapInteractionsToGraph.assertEquals((String)"12345", (String)stringArray2[1]);
    }

    public void testMapper2() throws Exception {
        ArrayList arrayList = new ArrayList();
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent("testData/psi_sample1.xml");
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        CyNetwork cyNetwork = Cytoscape.createNetwork((String)"network2");
        CyNode cyNode = Cytoscape.getCyNode((String)"YDL065C", (boolean)true);
        CyNode cyNode2 = Cytoscape.getCyNode((String)"YCR038C", (boolean)true);
        cyNetwork.addNode((Node)cyNode);
        cyNetwork.addNode((Node)cyNode2);
        CyEdge cyEdge = Cytoscape.getCyEdge((Node)cyNode, (Node)cyNode2, (String)"interaction", (Object)"pp", (boolean)true);
        cyEdge.setIdentifier("YDL065C (classical two hybrid, pmid:  11283351) YCR038C");
        MapPsiInteractionsToGraph mapPsiInteractionsToGraph = new MapPsiInteractionsToGraph(arrayList, cyNetwork, 2);
        mapPsiInteractionsToGraph.doMapping();
        int n = cyNetwork.getNodeCount();
        TestMapInteractionsToGraph.assertEquals((int)7, (int)n);
        int n2 = cyNetwork.getEdgeCount();
        TestMapInteractionsToGraph.assertEquals((int)6, (int)n2);
    }

    public void testMapper3() throws Exception {
        ArrayList arrayList = new ArrayList();
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent("testData/psi_sample2.xml");
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        CyNetwork cyNetwork = Cytoscape.createNetwork((String)"network3");
        MapInteractionsToGraph mapInteractionsToGraph = new MapInteractionsToGraph(arrayList, cyNetwork, 2);
        mapInteractionsToGraph.doMapping();
        int n = cyNetwork.getNodeCount();
        TestMapInteractionsToGraph.assertEquals((int)4, (int)n);
        int n2 = cyNetwork.getEdgeCount();
        TestMapInteractionsToGraph.assertEquals((int)6, (int)n2);
        Iterator iterator = cyNetwork.edgesIterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            String string2 = edge.getIdentifier();
            if (string2.equals("A <--> C")) {
                ++n3;
                continue;
            }
            if (string2.equals("A <--> D")) {
                ++n3;
                continue;
            }
            if (string2.equals("B <--> C")) {
                ++n3;
                continue;
            }
            if (string2.equals("B <--> D")) {
                ++n3;
                continue;
            }
            if (string2.equals("C <--> D")) {
                ++n3;
                continue;
            }
            if (!string2.equals("A <--> B")) continue;
            ++n3;
        }
        TestMapInteractionsToGraph.assertEquals((int)6, (int)n3);
    }

    public void testMapper4() throws Exception {
        ArrayList arrayList = new ArrayList();
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent("testData/psi_sample2.xml");
        MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, arrayList);
        mapPsiToInteractions.doMapping();
        CyNetwork cyNetwork = Cytoscape.createNetwork((String)"network3");
        MapInteractionsToGraph mapInteractionsToGraph = new MapInteractionsToGraph(arrayList, cyNetwork, 1);
        mapInteractionsToGraph.doMapping();
        int n = cyNetwork.getNodeCount();
        TestMapInteractionsToGraph.assertEquals((int)4, (int)n);
        int n2 = cyNetwork.getEdgeCount();
        TestMapInteractionsToGraph.assertEquals((int)3, (int)n2);
        Iterator iterator = cyNetwork.edgesIterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            String string2 = edge.getIdentifier();
            if (string2.equals("A <--> B")) {
                ++n3;
                continue;
            }
            if (string2.equals("A <--> C")) {
                ++n3;
                continue;
            }
            if (!string2.equals("A <--> D")) continue;
            ++n3;
        }
        TestMapInteractionsToGraph.assertEquals((int)3, (int)n3);
    }

    public void profileHprd() throws Exception {
        Object object;
        ArrayList arrayList = new ArrayList();
        ContentReader contentReader = new ContentReader();
        String string = contentReader.retrieveContent("testData/hprd.xml");
        for (int i = 0; i < 25; ++i) {
            object = new ArrayList();
            MapPsiToInteractions mapPsiToInteractions = new MapPsiToInteractions(string, (ArrayList)object);
            mapPsiToInteractions.doMapping();
            arrayList.addAll(object);
        }
        System.out.println("Mapping to Cytoscape Network");
        System.out.println("Number of Interactions:  " + arrayList.size());
        CyNetwork cyNetwork = Cytoscape.createNetwork((String)"network1");
        object = new MapPsiInteractionsToGraph(arrayList, cyNetwork, 2);
        ((MapInteractionsToGraph)object).doMapping();
        System.out.println("DONE");
    }

    public static void main(String[] stringArray) throws Exception {
        Date date = new Date();
        TestMapInteractionsToGraph testMapInteractionsToGraph = new TestMapInteractionsToGraph();
        testMapInteractionsToGraph.profileHprd();
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        System.out.println("Time:  " + l);
    }
}

