/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.test.live;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.TestCase;
import org.mskcc.dataservices.bio.Matrix;
import org.mskcc.dataservices.bio.StateInformation;
import org.mskcc.dataservices.live.DataServiceFactory;
import org.mskcc.dataservices.services.ReadStateInformation;

public class TestSoftStateService
extends TestCase {
    public void testSoftService0() throws Exception {
        DataServiceFactory dataServiceFactory = DataServiceFactory.getInstance();
        ReadStateInformation readStateInformation = (ReadStateInformation)dataServiceFactory.getService("READ_SOFT_FROM_FILE_OR_WEB");
        String string = new String("testData/soft/GDS330.soft");
        StateInformation stateInformation = readStateInformation.getStateInformation(string);
        ArrayList arrayList = stateInformation.getMatrices();
        TestSoftStateService.assertEquals((int)8, (int)arrayList.size());
    }

    public void testSoftService1() throws Exception {
        DataServiceFactory dataServiceFactory = DataServiceFactory.getInstance();
        ReadStateInformation readStateInformation = (ReadStateInformation)dataServiceFactory.getService("READ_SOFT_FROM_FILE_OR_WEB");
        String string = new String("testData/soft/GDS362.soft");
        StateInformation stateInformation = readStateInformation.getStateInformation(string);
        ArrayList arrayList = stateInformation.getMatrices();
        Matrix matrix = (Matrix)arrayList.get(0);
        String string2 = matrix.getTitle();
        TestSoftStateService.assertEquals((String)"^database", (String)string2);
        this.validateAttributes(matrix);
        matrix = (Matrix)arrayList.get(5);
        this.validateSubset(matrix);
        matrix = (Matrix)arrayList.get(6);
        this.validateDataHeaders(matrix);
        this.validateMatrixData(matrix);
    }

    public void testSoftService2() throws Exception {
        DataServiceFactory dataServiceFactory = DataServiceFactory.getInstance();
        ReadStateInformation readStateInformation = (ReadStateInformation)dataServiceFactory.getService("READ_SOFT_FROM_FILE_OR_WEB");
        String string = new String("testData/soft/softex_family.soft");
        StateInformation stateInformation = readStateInformation.getStateInformation(string);
        ArrayList arrayList = stateInformation.getMatrices();
        Matrix matrix = (Matrix)arrayList.get(0);
        String string2 = matrix.getTitle();
        TestSoftStateService.assertEquals((String)"^PLATFORM=my_array1", (String)string2);
        String string3 = matrix.getDataString(19, 11);
        TestSoftStateService.assertEquals((String)"ATGTAAAGTTTATTGTTGCTTCGCAGGGGGATTTGTTTTGTGTTTTGTTTGAGGCTTAGAACGCTGGTGC", (String)string3);
    }

    private void validateSubset(Matrix matrix) {
        String string = matrix.getTitle();
        TestSoftStateService.assertEquals((String)"^subset = GDS362_4", (String)string);
        String string2 = (String)matrix.getAttribute("subset_dataset_id");
        TestSoftStateService.assertEquals((String)"GDS362", (String)string2);
        string2 = (String)matrix.getAttribute("subset_description");
        TestSoftStateService.assertEquals((String)"no methyl methanesulfonate", (String)string2);
        string2 = (String)matrix.getAttribute("subset_sample_id");
        TestSoftStateService.assertEquals((String)"GSM6219,GSM6220,GSM6223,GSM6224", (String)string2);
        string2 = (String)matrix.getAttribute("subset_type");
        TestSoftStateService.assertEquals((String)"agent", (String)string2);
    }

    private void validateAttributes(Matrix matrix) {
        String[] stringArray = new String[]{"database_ref", "database_institute", "database_name", "database_email", "database_web_link"};
        HashMap hashMap = matrix.getAllAttributes();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            arrayList.add(string);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            TestSoftStateService.assertEquals((Object)stringArray[i], arrayList.get(i));
        }
    }

    private void validateDataHeaders(Matrix matrix) {
        String[] stringArray = new String[]{"ID_REF", "IDENTIFIER", "GSM6219", "GSM6220", "GSM6221", "GSM6222", "GSM6223", "GSM6224", "GSM6225", "GSM6226"};
        String[] stringArray2 = new String[]{"Platform reference identifier", "probe identifier", "Value for GSM6219: sgs (6-C-20211); src: sgs (6-C-20211)", "Value for GSM6220: sgs rep (5) C-20229; src: sgs rep (5) C-20229", "Value for GSM6221: sgs + mms (6-C-20212); src: sgs + mms (6-C-20212)", "Value for GSM6222: sgs mms rep (7) C-20230; src: sgs mms rep (7) C-20230", "Value for GSM6223: wt (2-20156); src: wt (2-20156)", "Value for GSM6224: wt rep (1)C-20239; src: wt rep (1)C-20239", "Value for GSM6225: wt + mms (4-C-20157); src: wt + mms (4-C-20157)", "Value for GSM6226: wt mms rep (3) C-20228; src: wt mms rep (3) C-20228"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = matrix.getDataHeaderName(i);
            String string2 = matrix.getDataHeaderDescription(i);
            TestSoftStateService.assertEquals((String)stringArray[i], (String)string);
            TestSoftStateService.assertEquals((String)stringArray2[i], (String)string2);
        }
    }

    private void validateMatrixData(Matrix matrix) {
        int n = 8362;
        String string = matrix.getDataString(n, 0);
        TestSoftStateService.assertEquals((String)"AFFX-YFL039CM_at", (String)string);
        string = matrix.getDataString(n, 1);
        TestSoftStateService.assertEquals((String)"AFFX-YFL039CM_at", (String)string);
        string = matrix.getDataString(n, 2);
        TestSoftStateService.assertEquals((String)"582.4", (String)string);
        string = matrix.getDataString(n, 3);
        TestSoftStateService.assertEquals((String)"618.7", (String)string);
        string = matrix.getDataString(n, 4);
        TestSoftStateService.assertEquals((String)"1176.6", (String)string);
        string = matrix.getDataString(n, 5);
        TestSoftStateService.assertEquals((String)"1022.2", (String)string);
        string = matrix.getDataString(n, 6);
        TestSoftStateService.assertEquals((String)"529", (String)string);
        string = matrix.getDataString(n, 7);
        TestSoftStateService.assertEquals((String)"449.9", (String)string);
        string = matrix.getDataString(n, 8);
        TestSoftStateService.assertEquals((String)"1333.7", (String)string);
        string = matrix.getDataString(n, 9);
        TestSoftStateService.assertEquals((String)"1025.7", (String)string);
    }
}

