/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelListener;
import cytoscape.view.cytopanels.CytoPanelState;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class CytoPanelAction
extends CytoscapeAction
implements CytoPanelListener {
    CytoPanel cytoPanel;
    private CytoPanelState cytoPanelPrevState = CytoPanelState.DOCK;
    JCheckBoxMenuItem menuItem;

    public CytoPanelAction(JCheckBoxMenuItem menuItem, CytoPanel cytoPanel) {
        super(cytoPanel.getTitle());
        this.setPreferredMenu("View.Desktop");
        this.cytoPanel = cytoPanel;
        this.menuItem = menuItem;
        cytoPanel.addCytoPanelListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.menuItem.isSelected()) {
            if (this.cytoPanelPrevState == CytoPanelState.DOCK) {
                this.cytoPanel.setState(CytoPanelState.DOCK);
            } else {
                this.cytoPanel.setState(CytoPanelState.FLOAT);
            }
            this.syncCheckbox(true);
        } else {
            this.cytoPanelPrevState = this.cytoPanel.getState();
            this.cytoPanel.setState(CytoPanelState.HIDE);
            this.syncCheckbox(false);
        }
    }

    public void onComponentAdded(int count) {
        this.menuItem.setEnabled(true);
    }

    public void onComponentRemoved(int count) {
        if (count == 0) {
            this.menuItem.setEnabled(false);
            this.menuItem.setSelected(false);
        }
    }

    public void onStateChange(CytoPanelState newState) {
        if (newState == CytoPanelState.DOCK || newState == CytoPanelState.FLOAT) {
            this.menuItem.setSelected(true);
        }
    }

    public void onComponentSelected(int componentIndex) {
    }

    private void syncCheckbox(boolean on) {
        AbstractButton targetCheckbox = null;
        JMenu targetMenu = Cytoscape.getDesktop().getCyMenus().getViewMenu();
        int menuCount = targetMenu.getMenuComponentCount();
        for (int i = 0; i < menuCount; ++i) {
            Component component = targetMenu.getMenuComponent(i);
            if (!component.getClass().equals(JCheckBoxMenuItem.class)) continue;
            if (this.cytoPanel.equals(Cytoscape.getDesktop().getCytoPanel(7)) && ((JCheckBoxMenuItem)component).getText().equals("Show/Hide network tree viewer")) {
                targetCheckbox = (JCheckBoxMenuItem)component;
                continue;
            }
            if (this.cytoPanel.equals(Cytoscape.getDesktop().getCytoPanel(5)) && ((JCheckBoxMenuItem)component).getText().equals("Show/Hide attribute browser")) {
                targetCheckbox = (JCheckBoxMenuItem)component;
                continue;
            }
            if (!this.cytoPanel.equals(Cytoscape.getDesktop().getCytoPanel(3)) || !((JCheckBoxMenuItem)component).getText().equals("Show/Hide advanced window")) continue;
            targetCheckbox = (JCheckBoxMenuItem)component;
        }
        if (targetCheckbox == null) {
            return;
        }
        if (on) {
            targetCheckbox.setSelected(true);
        } else {
            targetCheckbox.setSelected(false);
        }
    }
}

