/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.Semantics;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.annotation.Ontology;
import cytoscape.data.annotation.OntologyTerm;
import cytoscape.data.servers.BioDataServer;
import cytoscape.util.OpenBrowser;
import cytoscape.view.CyNetworkView;
import giny.view.NodeView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;

public class OntologyMapperDialog
extends JDialog {
    public static final String GO_MOLECULAR_FUNCTION = "GO Molecular Function";
    public static final String GO_BIOLOGICAL_PROCESS = "GO Biological Process";
    public static final String GO_CELLULAR_COMPONENT = "GO Cellular Component";
    private static final String AMIGO_URL = "http://www.godatabase.org/cgi-bin/amigo/go.cgi?view=details&search_constraint=terms&depth=0&query=";
    protected BioDataServer dataServer;
    protected String defaultSpecies;
    private AnnotationDescription[] annotationDescriptions;
    private TreePath annotationPath;
    private String currentAnnotationCategory;
    private CyNetworkView networkView;
    private CyNetwork network;
    private CyAttributes nodeAttributes;
    private JButton addEdgesButton;
    private JButton applyAllButton;
    private JButton applyButton;
    private JPanel buttonPanel;
    private JButton deleteCreatedButton;
    private JScrollPane goAttributeScrollPane;
    private JTree goAttributeTree;
    private JScrollPane goServerScrollPane;
    private JTree goServerTree;
    private JButton layoutButton;
    private JButton okButton;
    private JButton removeAllButton;
    private JButton removeButton;
    private JPopupMenu contextMenu;
    private JMenuItem amigoLink;

    public OntologyMapperDialog() {
        this.initDataStructures();
        this.initComponents();
    }

    public OntologyMapperDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initDataStructures();
        this.initComponents();
        this.appendCurrentAnnotaions();
    }

    private void initDataStructures() {
        this.nodeAttributes = Cytoscape.getNodeAttributes();
        this.networkView = Cytoscape.getCurrentNetworkView();
        this.network = this.networkView.getNetwork();
        this.dataServer = Cytoscape.getBioDataServer();
        this.annotationDescriptions = this.dataServer.getAnnotationDescriptions();
        Semantics.applyNamingServices(this.network);
        this.defaultSpecies = CytoscapeInit.getProperties().getProperty("defaultSpeciesName");
    }

    private void appendCurrentAnnotaions() {
        String[] attributeNames = this.nodeAttributes.getAttributeNames();
        for (int idx = 0; idx < attributeNames.length; ++idx) {
            TreeSet allTerms = new TreeSet();
            if (attributeNames[idx].startsWith(GO_MOLECULAR_FUNCTION) || attributeNames[idx].startsWith(GO_BIOLOGICAL_PROCESS) || attributeNames[idx].startsWith(GO_CELLULAR_COMPONENT)) {
                Iterator it = Cytoscape.getRootGraph().nodesIterator();
                while (it.hasNext()) {
                    CyNode node = (CyNode)it.next();
                    String nodeID = node.getIdentifier();
                    List listAttr = this.nodeAttributes.getListAttribute(nodeID, attributeNames[idx]);
                    if (listAttr == null || listAttr.size() == 0) continue;
                    allTerms.addAll(listAttr);
                }
            }
            if (allTerms.size() == 0) continue;
            String species = this.defaultSpecies;
            String[] parts = attributeNames[idx].split(" ");
            String curator = parts[0].trim();
            String annotationType = parts[1] + " " + parts[2];
            AnnotationDescription aDesc = new AnnotationDescription(species, curator, annotationType);
            this.appendToSelectionTree(attributeNames[idx], allTerms, aDesc);
        }
    }

    private void initComponents() {
        this.goServerScrollPane = new JScrollPane();
        this.goServerTree = new JTree();
        this.goAttributeScrollPane = new JScrollPane();
        this.goAttributeTree = new JTree();
        this.buttonPanel = new JPanel();
        this.applyButton = new JButton();
        this.removeButton = new JButton();
        this.applyAllButton = new JButton();
        this.removeAllButton = new JButton();
        this.layoutButton = new JButton();
        this.addEdgesButton = new JButton();
        this.deleteCreatedButton = new JButton();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Ontology Mapper");
        this.goServerScrollPane.setBorder(BorderFactory.createTitledBorder(null, "Ontologies in Local GO Server", 0, 0, new Font("Serif", 1, 12)));
        this.goServerTree = this.createAvailableAnnotationsTree();
        this.goServerTree.addTreeSelectionListener(new AddAnnotationTreeSelectionListener());
        this.goServerScrollPane.setViewportView(this.goServerTree);
        this.goAttributeTree = this.createNodeSelectionTree();
        this.goAttributeTree.addTreeSelectionListener(new SelectNodesTreeSelectionListener());
        this.goAttributeTree.addMouseListener(new PopupMenuListener());
        this.goAttributeTree.setToolTipText("Click to select nodes, or right click to open context menu.");
        this.goAttributeScrollPane.setBorder(BorderFactory.createTitledBorder(null, "GO Data as Attributes", 0, 0, new Font("Serif", 1, 12)));
        this.goAttributeScrollPane.setViewportView(this.goAttributeTree);
        this.applyButton.setFont(new Font("Serif", 1, 12));
        this.applyButton.setText(">>");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OntologyMapperDialog.this.applyButtonActionPerformed(evt);
            }
        });
        this.removeButton.setFont(new Font("Serif", 1, 12));
        this.removeButton.setText("<<");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OntologyMapperDialog.this.removeButtonActionPerformed(evt);
            }
        });
        this.applyAllButton.setText("Apply All");
        this.applyAllButton.setToolTipText("Apply all annotations in the selected category.");
        this.applyButton.setEnabled(false);
        this.applyAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OntologyMapperDialog.this.applyAllButtonActionPerformed(evt);
            }
        });
        this.removeAllButton.setText("Remove All");
        this.layoutButton.setText("Layout");
        this.addEdgesButton.setText("Add Edges");
        this.deleteCreatedButton.setText("Delete Created");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OntologyMapperDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.amigoLink = new JMenuItem("Search this GO term in AmiGO...");
        this.amigoLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                OpenBrowser.openURL(OntologyMapperDialog.this.getURL());
            }
        });
        this.contextMenu = new JPopupMenu();
        this.contextMenu.add(this.amigoLink);
        GroupLayout buttonPanelLayout = new GroupLayout((Container)this.buttonPanel);
        this.buttonPanel.setLayout((LayoutManager)buttonPanelLayout);
        buttonPanelLayout.setHorizontalGroup((GroupLayout.Group)buttonPanelLayout.createParallelGroup(1).add((GroupLayout.Group)buttonPanelLayout.createSequentialGroup().add((GroupLayout.Group)buttonPanelLayout.createParallelGroup(1).add((GroupLayout.Group)buttonPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)buttonPanelLayout.createParallelGroup(1).add(2, (Component)this.applyButton, -1, 120, Short.MAX_VALUE).add(2, (Component)this.removeButton, -1, 120, Short.MAX_VALUE).add(2, (Component)this.applyAllButton, -1, 120, Short.MAX_VALUE))).add((GroupLayout.Group)buttonPanelLayout.createSequentialGroup().add(45, 45, 45).add((Component)this.okButton))).addContainerGap()));
        buttonPanelLayout.setVerticalGroup((GroupLayout.Group)buttonPanelLayout.createParallelGroup(1).add(2, (GroupLayout.Group)buttonPanelLayout.createSequentialGroup().addContainerGap(103, Short.MAX_VALUE).add((Component)this.applyButton).add(23, 23, 23).add((Component)this.removeButton).add(23, 23, 23).add((Component)this.applyAllButton).add(123, 123, 123).add((Component)this.okButton)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.goServerScrollPane, -1, 350, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.buttonPanel, -2, -1, -2).addPreferredGap(0).add((Component)this.goAttributeScrollPane, -1, 350, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.buttonPanel, -1, -1, Short.MAX_VALUE).add(2, (Component)this.goAttributeScrollPane, -1, 400, Short.MAX_VALUE).add(2, (Component)this.goServerScrollPane, -1, 400, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private String getURL() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.goAttributeTree.getLastSelectedPathComponent();
        String nodeLabel = node.getUserObject().toString();
        String[] parts = nodeLabel.split("=");
        return AMIGO_URL + parts[0].trim();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        DefaultTreeModel model = (DefaultTreeModel)this.goAttributeTree.getModel();
        TreePath[] selectedPaths = this.goAttributeTree.getSelectionPaths();
        if (selectedPaths == null || selectedPaths.length == 0) {
            return;
        }
        for (int idx = 0; idx < selectedPaths.length; ++idx) {
            String annotationLevelName = selectedPaths[idx].getPathComponent(1).toString();
            DefaultMutableTreeNode lastPath = (DefaultMutableTreeNode)selectedPaths[idx].getPathComponent(1);
            lastPath.removeFromParent();
            model.reload();
            if (annotationLevelName == null) continue;
            this.nodeAttributes.deleteAttribute(annotationLevelName);
        }
    }

    private void applyAllButtonActionPerformed(ActionEvent evt) {
        int rootNodeCount = this.goServerTree.getModel().getChildCount(this.goServerTree.getModel().getRoot());
        for (int i = 0; i < rootNodeCount; ++i) {
            DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)this.goServerTree.getModel().getChild(this.goServerTree.getModel().getRoot(), i);
            AnnotationDescription aDesc = (AnnotationDescription)node1.getUserObject();
            if (aDesc == null) {
                return;
            }
            Set uniqueAnnotationValues = new HashSet();
            this.currentAnnotationCategory = aDesc.getCurator() + " " + aDesc.getType();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.goAttributeTree.getModel().getRoot();
            DefaultTreeModel model = (DefaultTreeModel)this.goAttributeTree.getModel();
            boolean skipFlag = false;
            for (int idx = 0; idx < model.getChildCount(root); ++idx) {
                String childrenName = model.getChild(root, idx).toString();
                if (!childrenName.equals(this.currentAnnotationCategory)) continue;
                skipFlag = true;
            }
            if (skipFlag) continue;
            uniqueAnnotationValues = this.addAllAnnotationToNodes(aDesc, this.currentAnnotationCategory);
            if (uniqueAnnotationValues.size() == 0) {
                this.showNoMatchErrorDialog();
            }
            if (uniqueAnnotationValues == null || uniqueAnnotationValues.size() <= 0) continue;
            this.appendToSelectionTree(this.currentAnnotationCategory, uniqueAnnotationValues, aDesc);
        }
    }

    private String formatGOID(Integer id) {
        String formattedID = "GO:";
        String idString = id.toString();
        if (idString.length() != 7) {
            int length = idString.length();
            for (int idx = 0; idx < 7 - length; ++idx) {
                formattedID = formattedID + "0";
            }
        }
        formattedID = formattedID + idString;
        return formattedID;
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode node1;
        boolean rootFlag = false;
        Set uniqueAnnotationValues = null;
        AnnotationDescription aDesc = null;
        if (this.annotationPath == null) {
            return;
        }
        if (this.annotationPath.getPathComponent(1) == this.annotationPath.getLastPathComponent()) {
            rootFlag = true;
            node1 = (DefaultMutableTreeNode)this.annotationPath.getPathComponent(1);
            aDesc = (AnnotationDescription)node1.getUserObject();
            if (aDesc == null) {
                return;
            }
            uniqueAnnotationValues = new HashSet();
            this.currentAnnotationCategory = aDesc.getCurator() + " " + aDesc.getType();
            uniqueAnnotationValues = this.addAllAnnotationToNodes(aDesc, this.currentAnnotationCategory);
        } else {
            node1 = (DefaultMutableTreeNode)this.annotationPath.getPathComponent(1);
            aDesc = (AnnotationDescription)node1.getUserObject();
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)this.annotationPath.getPathComponent(2);
            int level = (Integer)node2.getUserObject();
            if (aDesc == null) {
                return;
            }
            String baseAnnotationName = aDesc.getCurator() + " " + aDesc.getType();
            this.currentAnnotationCategory = baseAnnotationName + " (Level " + level + ")";
            uniqueAnnotationValues = this.addAnnotationToNodes(aDesc, level, this.currentAnnotationCategory);
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.goAttributeTree.getModel().getRoot();
        DefaultTreeModel model = (DefaultTreeModel)this.goAttributeTree.getModel();
        for (int idx = 0; idx < model.getChildCount(root); ++idx) {
            String childrenName = model.getChild(root, idx).toString();
            if (!childrenName.equals(this.currentAnnotationCategory)) continue;
            JOptionPane.showMessageDialog(this, "The annotation is already imported.", "Error!", 1);
            return;
        }
        CyAttributes nodeAtts = Cytoscape.getNodeAttributes();
        Iterator it = Cytoscape.getRootGraph().nodesIterator();
        HashSet<String> values = new HashSet<String>();
        Annotation anno = this.dataServer.getAnnotation(aDesc);
        Ontology onto = anno.getOntology();
        HashMap terms = onto.getTerms();
        HashMap reverse = new HashMap();
        Set termIDs = terms.keySet();
        for (Object id : termIDs) {
            OntologyTerm term = (OntologyTerm)terms.get(id);
            reverse.put(term.getName(), id);
        }
        while (it.hasNext()) {
            Object val;
            List vals;
            CyNode node = (CyNode)it.next();
            byte type = nodeAtts.getType(this.currentAnnotationCategory);
            if (type == 4) {
                String strVal = nodeAtts.getStringAttribute(node.getIdentifier(), this.currentAnnotationCategory);
                if (strVal == null) continue;
                values.add(strVal);
                continue;
            }
            if (type != -2 || (vals = nodeAtts.getListAttribute(node.getIdentifier(), this.currentAnnotationCategory)).size() <= 0 || !((val = vals.get(0)) instanceof String)) continue;
            for (String termName : vals) {
                String treeNode = this.formatGOID((Integer)reverse.get(termName)) + " = " + termName;
                values.add(treeNode);
            }
        }
        if (uniqueAnnotationValues.size() == 0) {
            this.showNoMatchErrorDialog();
        }
        if (uniqueAnnotationValues != null && uniqueAnnotationValues.size() > 0) {
            this.appendToSelectionTree(this.currentAnnotationCategory, uniqueAnnotationValues, aDesc);
        }
    }

    private void showNoMatchErrorDialog() {
        JOptionPane.showMessageDialog(null, "There is no match between the selected annotation \nand current nodes in the network.\n\nMake sure that your network data file \nand Gene Association files use same naming scheme.\n\nPlease compare the 3rd column of Gene Association\nfile (DB_Object_Symbol) and node names in your network.", "No match in Gene Ontology Database", 0);
    }

    protected void appendToSelectionTree(String currentAnnotationCategory, Set uniqueAnnotationValues, AnnotationDescription aDesc) {
        if (this.dataServer == null) {
            return;
        }
        Annotation anno = this.dataServer.getAnnotation(aDesc);
        if (anno == null) {
            return;
        }
        Ontology onto = anno.getOntology();
        HashMap terms = onto.getTerms();
        HashMap reverse = new HashMap();
        Set termIDs = terms.keySet();
        for (Object id : termIDs) {
            OntologyTerm term = (OntologyTerm)terms.get(id);
            reverse.put(term.getName(), id);
        }
        DefaultMutableTreeNode branch = new DefaultMutableTreeNode(currentAnnotationCategory);
        for (String termName : uniqueAnnotationValues) {
            String treeNode = this.formatGOID((Integer)reverse.get(termName)) + " = " + termName;
            branch.add(new DefaultMutableTreeNode(treeNode));
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.goAttributeTree.getModel().getRoot();
        DefaultTreeModel model = (DefaultTreeModel)this.goAttributeTree.getModel();
        model.insertNodeInto(branch, root, root.getChildCount());
        this.goAttributeTree.scrollPathToVisible(new TreePath(branch.getPath()));
        model.reload();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    protected JTree createAvailableAnnotationsTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Available Annotations");
        this.createTreeNodes(root, this.annotationDescriptions);
        JTree tree = new JTree(root);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        return tree;
    }

    protected void createTreeNodes(DefaultMutableTreeNode root, AnnotationDescription[] descriptions) {
        if (descriptions == null || descriptions.length == 0) {
            return;
        }
        Set speciesInGraph = Semantics.getSpeciesInNetwork(this.network);
        DefaultMutableTreeNode branch = null;
        Vector<String> topLevelNamesList = new Vector<String>();
        for (int i = 0; i < descriptions.length; ++i) {
            String species = descriptions[i].getSpecies();
            if (!speciesInGraph.contains(species)) continue;
            topLevelNamesList.add(descriptions[i].getCurator() + ", " + descriptions[i].getType() + ", " + descriptions[i].getSpecies());
            branch = new DefaultMutableTreeNode(descriptions[i]);
            Annotation annotation = this.dataServer.getAnnotation(descriptions[i]);
            if (annotation == null) continue;
            int maxDepth = annotation.maxDepth();
            for (int level = 0; level < maxDepth; ++level) {
                branch.add(new DefaultMutableTreeNode(new Integer(level + 1)));
            }
            root.add(branch);
        }
    }

    protected void buildOntologyTree() {
        Annotation anno = this.dataServer.getAnnotation(this.annotationDescriptions[0]);
        Ontology onto = anno.getOntology();
        Set keys = onto.getTerms().keySet();
        Iterator it = keys.iterator();
        System.out.println("Ontology for: " + anno.getType() + " ::: " + anno.getOntologyType());
        while (it.hasNext()) {
            Object key = it.next();
            OntologyTerm goTerm = onto.getTerm((Integer)key);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(goTerm.getName());
        }
    }

    private void depthFirst(int[] children) {
    }

    protected JTree createNodeSelectionTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Annotations Categories");
        JTree tree = new JTree(root);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        this.expandAll(tree, new TreePath(root), true);
        return tree;
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public Set addAnnotationToNodes(AnnotationDescription aDesc, int level, String annotationNameAtLevel) {
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        nodeAttributes.deleteAttribute(annotationNameAtLevel);
        Iterator it = Cytoscape.getRootGraph().nodesIterator();
        TreeSet allTerms = new TreeSet();
        while (it.hasNext()) {
            CyNode node = (CyNode)it.next();
            String label = node.getIdentifier();
            String[][] fullAnnotations = this.dataServer.getAllAnnotations(aDesc, label);
            if (fullAnnotations.length == 0) continue;
            String[] uniqueAnnotationsAtLevel = this.collapseToUniqueAnnotationsAtLevel(fullAnnotations, level);
            ArrayList<String> annotsList = new ArrayList<String>();
            if (uniqueAnnotationsAtLevel.length == 0) {
                nodeAttributes.setAttribute(label, annotationNameAtLevel, "");
                continue;
            }
            for (int j = 0; j < uniqueAnnotationsAtLevel.length; ++j) {
                annotsList.add(uniqueAnnotationsAtLevel[j]);
            }
            if (annotsList.size() == 0) continue;
            nodeAttributes.setListAttribute(label, annotationNameAtLevel, annotsList);
            allTerms.addAll(annotsList);
        }
        return allTerms;
    }

    public Set addAllAnnotationToNodes(AnnotationDescription aDesc, String annotationName) {
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        Iterator it = Cytoscape.getRootGraph().nodesIterator();
        TreeSet allTerms = new TreeSet();
        while (it.hasNext()) {
            TreeSet uniqueTerms = new TreeSet();
            CyNode node = (CyNode)it.next();
            String label = node.getIdentifier();
            String[][] fullAnnotations = this.dataServer.getAllAnnotations(aDesc, label);
            if (fullAnnotations.length != 0) {
                ArrayList<String> termList = new ArrayList<String>();
                for (int i = 0; i < fullAnnotations.length; ++i) {
                    for (int j = 0; j < fullAnnotations[i].length; ++j) {
                        termList.add(fullAnnotations[i][j]);
                    }
                }
                uniqueTerms.addAll(termList);
            }
            ArrayList convertedList = new ArrayList();
            convertedList.addAll(uniqueTerms);
            if (convertedList.size() != 0) {
                nodeAttributes.setListAttribute(label, annotationName, convertedList);
            }
            allTerms.addAll(uniqueTerms);
        }
        return allTerms;
    }

    private String[] collapseToUniqueAnnotationsAtLevel(String[][] fullAnnotations, int level) {
        Vector<String> collector = new Vector<String>();
        for (int i = 0; i < fullAnnotations.length; ++i) {
            String annotationAtLevel;
            int indexOfClosestAvailableLevel = level - 1;
            if (indexOfClosestAvailableLevel > fullAnnotations[i].length - 1) {
                indexOfClosestAvailableLevel = fullAnnotations[i].length - 1;
            }
            if (collector.contains(annotationAtLevel = fullAnnotations[i][indexOfClosestAvailableLevel])) continue;
            collector.add(annotationAtLevel);
        }
        return collector.toArray(new String[0]);
    }

    class SelectNodesTreeSelectionListener
    implements TreeSelectionListener {
        SelectNodesTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)OntologyMapperDialog.this.goAttributeTree.getLastSelectedPathComponent();
            if (node == null) {
                OntologyMapperDialog.this.removeButton.setEnabled(false);
                return;
            }
            if (!node.isLeaf()) {
                OntologyMapperDialog.this.removeButton.setEnabled(true);
                return;
            }
            CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
            Iterator nvi = OntologyMapperDialog.this.networkView.getNodeViewsIterator();
            while (nvi.hasNext()) {
                ((NodeView)nvi.next()).setSelected(false);
            }
            TreePath[] selectedPaths = OntologyMapperDialog.this.goAttributeTree.getSelectionPaths();
            HashMap selectionHash = this.extractAnnotationsFromSelection(selectedPaths);
            Iterator nvi2 = OntologyMapperDialog.this.networkView.getNodeViewsIterator();
            block1: while (nvi2.hasNext()) {
                NodeView nv = (NodeView)nvi2.next();
                String nodeLabel = nv.getNode().getIdentifier();
                if (nodeLabel == null) continue;
                for (String name : selectionHash.keySet()) {
                    Vector categoryList = (Vector)selectionHash.get(name);
                    byte type = nodeAttributes.getType(name);
                    if (type == 4) {
                        String attributeValue = nodeAttributes.getStringAttribute(nodeLabel, name);
                        if (attributeValue == null || !categoryList.contains(attributeValue)) continue block1;
                        nv.setSelected(true);
                        continue block1;
                    }
                    if (type != -2) continue;
                    boolean hit = false;
                    List attributeList = nodeAttributes.getListAttribute(nodeLabel, name);
                    Iterator ali = attributeList.iterator();
                    while (ali.hasNext()) {
                        if (!categoryList.contains(ali.next())) continue;
                        nv.setSelected(true);
                        hit = true;
                        break;
                    }
                    if (!hit) continue;
                    continue block1;
                }
            }
            OntologyMapperDialog.this.removeButton.setEnabled(false);
            OntologyMapperDialog.this.networkView.redrawGraph(false, false);
        }

        protected HashMap extractAnnotationsFromSelection(TreePath[] paths) {
            HashMap<String, Vector> hash = new HashMap<String, Vector>();
            for (int i = 0; i < paths.length; ++i) {
                Vector list;
                String annotationName = paths[i].getPathComponent(1).toString();
                String annotationValue = paths[i].getPathComponent(2).toString();
                String[] parts = annotationValue.split("=");
                annotationValue = parts[1].trim();
                if (!hash.containsKey(annotationName)) {
                    list = new Vector();
                    hash.put(annotationName, list);
                }
                list = (Vector)hash.get(annotationName);
                list.add(annotationValue);
            }
            return hash;
        }
    }

    class PopupMenuListener
    implements MouseListener {
        PopupMenuListener() {
        }

        public void mouseClicked(MouseEvent arg0) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)OntologyMapperDialog.this.goAttributeTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (!node.isLeaf()) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(arg0)) {
                OntologyMapperDialog.this.contextMenu.show(arg0.getComponent(), arg0.getX(), arg0.getY());
            } else if (SwingUtilities.isMiddleMouseButton(arg0) || SwingUtilities.isLeftMouseButton(arg0)) {
                // empty if block
            }
        }

        public void mouseEntered(MouseEvent arg0) {
        }

        public void mouseExited(MouseEvent arg0) {
        }

        public void mousePressed(MouseEvent arg0) {
        }

        public void mouseReleased(MouseEvent arg0) {
        }
    }

    class AddAnnotationTreeSelectionListener
    implements TreeSelectionListener {
        AddAnnotationTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)OntologyMapperDialog.this.goServerTree.getLastSelectedPathComponent();
            if (node == null) {
                OntologyMapperDialog.this.applyButton.setEnabled(false);
                return;
            }
            if (!node.isLeaf()) {
                OntologyMapperDialog.this.applyButton.setEnabled(true);
                OntologyMapperDialog.this.annotationPath = OntologyMapperDialog.this.goServerTree.getSelectionPaths()[0];
                return;
            }
            OntologyMapperDialog.this.applyButton.setEnabled(true);
            OntologyMapperDialog.this.annotationPath = OntologyMapperDialog.this.goServerTree.getSelectionPaths()[0];
        }
    }
}

