/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms.readers;

import cytoscape.data.readers.TextFileReader;
import cytoscape.data.readers.TextHttpReader;
import cytoscape.data.readers.TextJarReader;
import cytoscape.data.synonyms.Thesaurus;
import java.io.BufferedReader;
import java.util.Vector;

public class ThesaurusFlatFileReader {
    Thesaurus thesaurus;
    String fullText;
    String[] lines;
    boolean flip;

    public ThesaurusFlatFileReader(String filename) throws Exception {
        this.flip = false;
        try {
            if (filename.trim().startsWith("jar://")) {
                TextJarReader reader = new TextJarReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else if (filename.trim().startsWith("http://")) {
                TextHttpReader reader = new TextHttpReader(filename);
                reader.read();
                this.fullText = reader.getText();
            } else {
                TextFileReader reader = new TextFileReader(filename);
                reader.read();
                this.fullText = reader.getText();
            }
        }
        catch (Exception e0) {
            System.err.println("-- Exception while reading ontology flat file " + filename);
            System.err.println(e0.getMessage());
            return;
        }
        this.read();
    }

    public ThesaurusFlatFileReader(BufferedReader rd, boolean isFlip) throws Exception {
        Vector<String> extractedLines = null;
        this.flip = isFlip;
        this.fullText = null;
        extractedLines = new Vector<String>();
        String curLine = null;
        while (null != (curLine = rd.readLine())) {
            extractedLines.add(curLine);
        }
        rd.close();
        Object[] entireFile = extractedLines.toArray();
        this.lines = new String[entireFile.length];
        try {
            System.arraycopy(entireFile, 0, this.lines, 0, this.lines.length);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        this.read();
    }

    private void read() throws Exception {
        if (this.fullText != null) {
            this.lines = this.fullText.split("\n");
        }
        String species = this.lines[0].trim();
        this.thesaurus = new Thesaurus(species);
        for (int i = 1; i < this.lines.length; ++i) {
            int t;
            String[] tokens;
            String line = this.lines[i].trim();
            if (line.startsWith("#") || line.length() < 3 || (tokens = this.lines[i].split("\\s+", 0)).length < 2) continue;
            String canonicalName = tokens[0].trim();
            String commonName = tokens[1].trim();
            if (canonicalName.length() == 0 || commonName.length() == 0) continue;
            if (!this.flip) {
                this.thesaurus.add(canonicalName, commonName);
                for (t = 2; t < tokens.length; ++t) {
                    this.thesaurus.addAlternateCommonName(canonicalName, tokens[t].trim());
                }
                continue;
            }
            if (!this.flip) continue;
            this.thesaurus.add(commonName, canonicalName);
            for (t = 2; t < tokens.length; ++t) {
                this.thesaurus.addAlternateCommonName(commonName, tokens[t].trim());
            }
        }
    }

    public Thesaurus getThesaurus() {
        return this.thesaurus;
    }
}

