/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import java.awt.Color;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Misc {
    public static Color parseRGBText(String text) {
        StringTokenizer strtok = new StringTokenizer(text, ",");
        if (strtok.countTokens() != 3) {
            System.err.println("illegal RGB string in EdgeViz.parseRGBText: " + text);
            return Color.black;
        }
        String red = strtok.nextToken().trim();
        String green = strtok.nextToken().trim();
        String blue = strtok.nextToken().trim();
        try {
            int r = Integer.parseInt(red);
            int g = Integer.parseInt(green);
            int b = Integer.parseInt(blue);
            return new Color(r, g, b);
        }
        catch (NumberFormatException e) {
            return Color.black;
        }
    }

    public static String getRGBText(Color color) {
        Integer red = new Integer(color.getRed());
        Integer green = new Integer(color.getGreen());
        Integer blue = new Integer(color.getBlue());
        return new String(red.toString() + "," + green.toString() + "," + blue.toString());
    }

    public static Vector getPropertyValues(Properties props, String propName) {
        String propertyDelimiterName = "property.token.delimiter";
        String delimiter = props.getProperty(propertyDelimiterName, "::");
        String listStartTokenName = "list.startToken";
        String listStartToken = props.getProperty(listStartTokenName, "(");
        String listEndTokenName = "list.endToken";
        String listEndToken = props.getProperty(listEndTokenName, ")");
        Vector<String> result = new Vector<String>();
        String propString = props.getProperty(propName);
        if (propString == null) {
            return result;
        }
        String propStringTrimmed = propString.trim();
        String[] tokens = Misc.parseList(propStringTrimmed, listStartToken, listEndToken, delimiter);
        for (int i = 0; i < tokens.length; ++i) {
            result.add(tokens[i]);
        }
        return result;
    }

    public static boolean isList(String listString, String startToken, String endToken, String delimiter) {
        String s = listString.trim();
        Vector list = new Vector();
        return s.startsWith(startToken) && s.endsWith(endToken);
    }

    public static String[] parseList(String listString, String startToken, String endToken, String delimiter) {
        String s = listString.trim();
        if (s.startsWith(startToken) && s.endsWith(endToken)) {
            s = s.substring(1, s.length() - 1);
            return s.split(delimiter);
        }
        String[] unparseableResult = new String[]{listString};
        return unparseableResult;
    }
}

