/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static final int DEF_COMPRESSION_LEVEL = 1;
    private String zipArchiveName;
    private String[] inputFiles;
    private String inputFileDir;
    private int fileCount;
    private String sessionDirName;
    private HashMap pluginFileMap = null;
    private static final String FS = "/";

    public ZipUtil(String zipFile, String[] fileNameList, String sessionDir) {
        this(zipFile, fileNameList, sessionDir, "");
    }

    public ZipUtil(String zipFile, String[] fileNameList, String sessionDir, String fileDir) {
        this.zipArchiveName = zipFile;
        this.fileCount = fileNameList.length;
        this.inputFiles = new String[this.fileCount];
        this.sessionDirName = sessionDir;
        this.inputFileDir = fileDir;
        System.arraycopy(fileNameList, 0, this.inputFiles, 0, this.fileCount);
    }

    private void clean() {
        for (int i = 0; i < this.fileCount; ++i) {
            File tempFile = new File(this.inputFileDir + this.inputFiles[i]);
            tempFile.delete();
        }
    }

    public void compressFast(int compressionLevel, boolean cleanFlag) throws IOException {
        CRC32 crc32 = new CRC32();
        byte[] rgb = new byte[5000];
        ZipOutputStream zipOS = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.zipArchiveName)));
        zipOS.setMethod(8);
        if (compressionLevel >= 0 && compressionLevel <= 9) {
            zipOS.setLevel(compressionLevel);
        } else {
            zipOS.setLevel(1);
        }
        String targetName = "";
        for (int i = 0; i < this.fileCount; ++i) {
            File file = new File(this.inputFileDir + this.inputFiles[i]);
            targetName = this.sessionDirName + FS + this.inputFiles[i];
            this.addEntryToZip(file, targetName, zipOS, crc32, rgb);
        }
        if (this.pluginFileMap != null && this.pluginFileMap.size() > 0) {
            Set pluginSet = this.pluginFileMap.keySet();
            for (String pluginName : pluginSet) {
                List theFileList = (List)this.pluginFileMap.get(pluginName);
                if (theFileList == null || theFileList.size() == 0) continue;
                for (File theFile : theFileList) {
                    if (theFile == null || !theFile.exists()) continue;
                    targetName = this.sessionDirName + FS + "plugins" + FS + pluginName + FS + theFile.getName();
                    this.addEntryToZip(theFile, targetName, zipOS, crc32, rgb);
                }
            }
        }
        zipOS.close();
        if (cleanFlag) {
            this.clean();
        }
    }

    public void setPluginFileMap(HashMap pMap) {
        this.pluginFileMap = pMap;
    }

    private void addEntryToZip(File srcFile, String targetName, ZipOutputStream zipOS, CRC32 crc32, byte[] rgb) throws IOException {
        int numRead;
        FileInputStream fileIS = new FileInputStream(srcFile);
        while ((numRead = fileIS.read(rgb)) > -1) {
            crc32.update(rgb, 0, numRead);
        }
        fileIS.close();
        ZipEntry zipEntry = new ZipEntry(targetName);
        zipEntry.setSize(srcFile.length());
        zipEntry.setTime(srcFile.lastModified());
        zipEntry.setCrc(crc32.getValue());
        zipOS.putNextEntry(zipEntry);
        fileIS = new FileInputStream(srcFile);
        while ((numRead = fileIS.read(rgb)) > -1) {
            zipOS.write(rgb, 0, numRead);
        }
        fileIS.close();
        zipOS.closeEntry();
    }

    public static InputStream readFile(String zipName, String fileNameRegEx) throws IOException {
        ZipFile sessionZipFile = new ZipFile(zipName);
        Enumeration<? extends ZipEntry> zipEntries = sessionZipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zent = zipEntries.nextElement();
            if (!zent.getName().matches(fileNameRegEx)) continue;
            return sessionZipFile.getInputStream(zent);
        }
        return null;
    }
}

