/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.calculators;

import cytoscape.CyNetwork;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.calculators.AbstractNodeSizeCalculator;
import cytoscape.visual.calculators.NodeSizeCalculator;
import cytoscape.visual.mappings.ObjectMapping;
import giny.model.Node;
import java.util.Properties;

public class GenericNodeSizeCalculator
extends AbstractNodeSizeCalculator
implements NodeSizeCalculator {
    public byte getType() {
        return this.sizeType;
    }

    public String getPropertyLabel() {
        return this.propertyLabel;
    }

    public String getTypeName() {
        return this.typename;
    }

    protected String getClassName() {
        if (this.sizeType == 4) {
            return "cytoscape.visual.calculators.GenericNodeUniformSizeCalculator";
        }
        if (this.sizeType == 127) {
            return "cytoscape.visual.calculators.GenericNodeWidthCalculator";
        }
        if (this.sizeType == 126) {
            return "cytoscape.visual.calculators.GenericNodeHeightCalculator";
        }
        return this.getClass().getName();
    }

    GenericNodeSizeCalculator() {
        this.set((byte)4, "nodeUniformSizeCalculator", "Node Size");
    }

    public GenericNodeSizeCalculator(String name, ObjectMapping m) {
        super(name, m);
        this.set((byte)4, "nodeUniformSizeCalculator", "Node Size");
    }

    public GenericNodeSizeCalculator(String name, Properties props, String baseKey) {
        super(name, props, baseKey);
        this.set((byte)4, "nodeUniformSizeCalculator", "Node Size");
    }

    public void apply(NodeAppearance appr, Node node, CyNetwork network) {
        if (this.sizeType == 127) {
            this.apply(appr, node, network, this.WIDTH);
        } else if (this.sizeType == 126) {
            this.apply(appr, node, network, this.HEIGHT);
        } else if (this.sizeType == 4) {
            this.apply(appr, node, network, this.SIZE);
        } else {
            System.err.println("don't know what kind of calculator this is!");
        }
    }

    public double calculateNodeSize(Node e, CyNetwork n) {
        NodeAppearance ea = new NodeAppearance();
        this.apply(ea, e, n);
        if (this.sizeType == 127) {
            return ea.getWidth();
        }
        if (this.sizeType == 126) {
            return ea.getHeight();
        }
        if (this.sizeType == 4) {
            return ea.getSize();
        }
        return -1.0;
    }
}

