/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.Interaction;
import cytoscape.data.readers.AbstractGraphReader;
import cytoscape.data.servers.BioDataServer;
import cytoscape.task.TaskMonitor;
import cytoscape.util.FileUtil;
import cytoscape.util.PercentUtil;
import giny.view.GraphView;
import giny.view.NodeView;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class InteractionsReader
extends AbstractGraphReader {
    private TaskMonitor taskMonitor;
    private PercentUtil percentUtil;
    protected Vector allInteractions = new Vector();
    BioDataServer dataServer;
    String species;
    String zip_entry;
    boolean is_zip = false;
    IntArrayList node_indices;
    OpenIntIntHashMap edges;

    public InteractionsReader(BioDataServer dataServer, String species, String filename) {
        this(filename, null);
    }

    public InteractionsReader(BioDataServer dataServer, String species, String filename, TaskMonitor taskMonitor) {
        this(filename, taskMonitor);
    }

    public InteractionsReader(BioDataServer dataServer, String species, String zip_entry, boolean is_zip) {
        this(zip_entry, null, is_zip);
    }

    public InteractionsReader(String zip_entry, TaskMonitor monitor, boolean is_zip) {
        super("zip_data");
        this.zip_entry = zip_entry;
        this.is_zip = is_zip;
        this.taskMonitor = monitor;
    }

    public InteractionsReader(String filename) {
        this(filename, null);
    }

    public InteractionsReader(String filename, TaskMonitor monitor) {
        super(filename);
        this.taskMonitor = monitor;
    }

    public void layout(GraphView view) {
        double distanceBetweenNodes = 50.0;
        int columns = (int)Math.sqrt(view.nodeCount());
        Iterator nodeViews = view.getNodeViewsIterator();
        double currX = 0.0;
        double currY = 0.0;
        int count = 0;
        while (nodeViews.hasNext()) {
            NodeView nView = (NodeView)nodeViews.next();
            nView.setOffset(currX, currY);
            if (++count == columns) {
                count = 0;
                currX = 0.0;
                currY += distanceBetweenNodes;
                continue;
            }
            currX += distanceBetweenNodes;
        }
    }

    public void read(boolean canonicalize) throws IOException {
        String rawText = !this.is_zip ? FileUtil.getInputString(this.fileName) : this.zip_entry;
        String delimiter = " ";
        if (rawText.indexOf("\t") >= 0) {
            delimiter = "\t";
        }
        String[] lines = rawText.split(System.getProperty("line.separator"));
        if (this.taskMonitor != null) {
            this.percentUtil = new PercentUtil(6);
        }
        for (int i = 0; i < lines.length; ++i) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(1, i, lines.length));
            }
            String newLine = lines[i];
            Interaction newInteraction = new Interaction(newLine, delimiter);
            this.allInteractions.addElement(newInteraction);
        }
        this.createRootGraphFromInteractionData(canonicalize);
    }

    public void read() throws IOException {
        this.read(false);
    }

    public int getCount() {
        return this.allInteractions.size();
    }

    public Interaction[] getAllInteractions() {
        Interaction[] result = new Interaction[this.allInteractions.size()];
        for (int i = 0; i < this.allInteractions.size(); ++i) {
            Interaction inter;
            result[i] = inter = (Interaction)this.allInteractions.elementAt(i);
        }
        return result;
    }

    protected String canonicalizeName(String name) {
        String canonicalName = name;
        if (this.dataServer != null && (canonicalName = this.dataServer.getCanonicalName(this.species, name)) == null) {
            canonicalName = name;
        }
        return canonicalName;
    }

    protected void createRootGraphFromInteractionData(boolean canonicalize) {
        Interaction[] interactions = this.getAllInteractions();
        HashSet<String> nodeNameSet = new HashSet<String>();
        int edgeCount = 0;
        for (int i = 0; i < interactions.length; ++i) {
            Interaction interaction = interactions[i];
            String sourceName = interaction.getSource();
            if (canonicalize) {
                sourceName = this.canonicalizeName(sourceName);
            }
            nodeNameSet.add(sourceName);
            String[] targets = interaction.getTargets();
            for (int t = 0; t < targets.length; ++t) {
                String targetNodeName = targets[t];
                if (canonicalize) {
                    targetNodeName = this.canonicalizeName(targetNodeName);
                }
                nodeNameSet.add(targetNodeName);
                ++edgeCount;
            }
            if (this.taskMonitor == null) continue;
            this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(2, i, interactions.length));
        }
        Cytoscape.ensureCapacity(nodeNameSet.size(), edgeCount);
        this.node_indices = new IntArrayList(nodeNameSet.size());
        this.edges = new OpenIntIntHashMap(edgeCount);
        int counter = 0;
        for (String nodeName : nodeNameSet) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(3, counter, nodeNameSet.size()));
                ++counter;
            }
            CyNode node = Cytoscape.getCyNode(nodeName, true);
            this.node_indices.add(node.getRootGraphIndex());
        }
        for (int i = 0; i < interactions.length; ++i) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(4, i, interactions.length));
            }
            Interaction interaction = interactions[i];
            String nodeName = interaction.getSource();
            if (canonicalize) {
                nodeName = this.canonicalizeName(interaction.getSource());
            }
            String interactionType = interaction.getType();
            String[] targets = interaction.getTargets();
            for (int t = 0; t < targets.length; ++t) {
                String targetNodeName = canonicalize ? this.canonicalizeName(targets[t]) : targets[t];
                String edgeName = CyEdge.createIdentifier(nodeName, interactionType, targetNodeName);
                CyEdge edge = Cytoscape.getCyEdge(nodeName, edgeName, targetNodeName, interactionType);
                this.edges.put(edge.getRootGraphIndex(), 0);
            }
        }
    }

    public int[] getNodeIndicesArray() {
        this.node_indices.trimToSize();
        return this.node_indices.elements();
    }

    public int[] getEdgeIndicesArray() {
        IntArrayList edge_indices = new IntArrayList(this.edges.size());
        this.edges.keys(edge_indices);
        edge_indices.trimToSize();
        return edge_indices.elements();
    }
}

