/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.action;

import csplugins.dataviewer.model.UserSelection;
import cytoscape.CyEdge;
import cytoscape.CyNode;
import cytoscape.data.FlagEvent;
import cytoscape.data.FlagEventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.mskcc.dataservices.bio.Interaction;
import org.mskcc.dataservices.bio.Interactor;

public class DisplayDetails
implements FlagEventListener {
    private HashMap cyMap;
    private UserSelection userSelection;
    private int totalNumNodesSelected = 0;
    private int totalNumEdgesSelected = 0;

    public DisplayDetails(HashMap hashMap, UserSelection userSelection) {
        this.cyMap = hashMap;
        this.userSelection = userSelection;
    }

    public void onFlagEvent(FlagEvent flagEvent) {
        int n = flagEvent.getTargetType();
        if (n == 2) {
            HashSet hashSet = (HashSet)flagEvent.getTarget();
            this.trackTotalNumberNodesSelected(flagEvent, hashSet);
            if (flagEvent.getEventType() && this.totalNumNodesSelected < 3) {
                Iterator iterator = hashSet.iterator();
                CyNode cyNode = (CyNode)iterator.next();
                String string = cyNode.getIdentifier();
                Interactor interactor = (Interactor)this.cyMap.get(string);
                this.userSelection.setSelectedInteractor(string, interactor);
            }
        } else if (n == 3) {
            HashSet hashSet = (HashSet)flagEvent.getTarget();
            this.trackTotalNumEdgesSelected(flagEvent, hashSet);
            if (flagEvent.getEventType() && this.totalNumEdgesSelected < 3) {
                Iterator iterator = hashSet.iterator();
                CyEdge cyEdge = (CyEdge)iterator.next();
                String string = cyEdge.getIdentifier();
                Interaction interaction = (Interaction)this.cyMap.get(string);
                this.userSelection.setSelectedInteraction(interaction);
            }
        }
    }

    private void trackTotalNumEdgesSelected(FlagEvent flagEvent, HashSet hashSet) {
        this.totalNumEdgesSelected = flagEvent.getEventType() ? (this.totalNumEdgesSelected += hashSet.size()) : (this.totalNumEdgesSelected -= hashSet.size());
    }

    private void trackTotalNumberNodesSelected(FlagEvent flagEvent, HashSet hashSet) {
        this.totalNumNodesSelected = flagEvent.getEventType() ? (this.totalNumNodesSelected += hashSet.size()) : (this.totalNumNodesSelected -= hashSet.size());
    }
}

