/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.test.live;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.mskcc.dataservices.bio.ExternalReference;
import org.mskcc.dataservices.bio.Interaction;
import org.mskcc.dataservices.bio.Interactor;
import org.mskcc.dataservices.live.interaction.ReadPsiFromFileOrWeb;

public class TestReadPsiFromFileOrWeb
extends TestCase {
    public void testPsiService() throws Exception {
        ReadPsiFromFileOrWeb readPsiFromFileOrWeb = new ReadPsiFromFileOrWeb();
        String string = new String("testData/psi_sample1.xml");
        readPsiFromFileOrWeb.getInteractionsFromUrl(string);
        ArrayList arrayList = readPsiFromFileOrWeb.getInteractionsFromUrl(string);
        Interaction interaction = (Interaction)arrayList.get(1);
        this.validateInteraction(interaction);
    }

    private void validateInteraction(Interaction interaction) {
        String string = (String)interaction.getAttribute("PUB_MED_ID");
        String string2 = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_NAME");
        TestReadPsiFromFileOrWeb.assertEquals((String)"11283351", (String)string);
        TestReadPsiFromFileOrWeb.assertEquals((String)"classical two hybrid", (String)string2);
        ArrayList arrayList = interaction.getInteractors();
        Interactor interactor = (Interactor)arrayList.get(0);
        TestReadPsiFromFileOrWeb.assertEquals((String)"YCR038C", (String)interactor.getName());
        TestReadPsiFromFileOrWeb.assertEquals((Object)"GTP/GDP exchange factor for Rsr1 protein", (Object)interactor.getAttribute("FULL_NAME"));
        Interactor interactor2 = (Interactor)arrayList.get(1);
        TestReadPsiFromFileOrWeb.assertEquals((String)"YDL065C", (String)interactor2.getName());
        TestReadPsiFromFileOrWeb.assertEquals((Object)"40 kDa farnesylated protein associated with peroxisomes", (Object)interactor2.getAttribute("FULL_NAME"));
        ExternalReference[] externalReferenceArray = interactor2.getExternalRefs();
        TestReadPsiFromFileOrWeb.assertEquals((String)"Entrez GI", (String)externalReferenceArray[0].getDatabase());
        TestReadPsiFromFileOrWeb.assertEquals((String)"1431072", (String)externalReferenceArray[0].getId());
    }
}

