/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.ui;

import csplugins.dataviewer.ui.Console;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class ConsolePanel
extends JPanel
implements Console {
    private JTextPane ta;
    private JScrollPane scrollPane;

    public ConsolePanel() {
        this.setLayout(new BorderLayout());
        this.ta = new JTextPane();
        this.ta.setMargin(new Insets(5, 7, 5, 7));
        this.ta.setEditable(false);
        this.ta.setBackground(Color.WHITE);
        this.ta.setForeground(Color.BLACK);
        this.addStylesToDocument(this.ta.getStyledDocument());
        Font font = new Font("Courier", 0, 12);
        this.ta.setFont(font);
        this.scrollPane = new JScrollPane(this.ta);
        StyledDocument styledDocument = this.ta.getStyledDocument();
        try {
            styledDocument.insertString(styledDocument.getLength(), "Welcome to the Cytoscape cPath PlugIn.\n", styledDocument.getStyle("bold"));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.add((Component)this.scrollPane, "Center");
    }

    public void logMessage(String string) {
        this.logMessage(string, "regular");
    }

    public void logMessageBold(String string) {
        this.logMessage(string, "bold");
    }

    public void clear() {
        this.ta.setText("");
    }

    private void logMessage(String string, String string2) {
        StyledDocument styledDocument = this.ta.getStyledDocument();
        try {
            styledDocument.insertString(styledDocument.getLength(), string + "\n", styledDocument.getStyle(string2));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.ta.setCaretPosition(this.ta.getDocument().getLength());
    }

    protected void addStylesToDocument(StyledDocument styledDocument) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = styledDocument.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "SansSerif");
        Style style3 = styledDocument.addStyle("italic", style2);
        StyleConstants.setItalic(style3, true);
        style3 = styledDocument.addStyle("bold", style2);
        StyleConstants.setBold(style3, true);
        style3 = styledDocument.addStyle("small", style2);
        StyleConstants.setFontSize(style3, 10);
        style3 = styledDocument.addStyle("large", style2);
        StyleConstants.setFontSize(style3, 16);
    }
}

