/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class QuickReferenceDialog
implements ActionListener {
    private static final int WIDTH = 400;
    private static final int HEIGHT = 450;
    private JFrame parent;
    private JFrame helpFrame;

    public QuickReferenceDialog(JFrame jFrame) {
        this.parent = jFrame;
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.parent != null) {
            Point point = this.parent.getLocation();
            Dimension dimension = this.parent.getSize();
            int n = (int)(point.getX() + dimension.getWidth() / 2.0 - 200.0);
            int n2 = (int)(point.getY() + dimension.getHeight() / 2.0 - 225.0);
            this.helpFrame.setLocation(n, n2);
        }
        this.helpFrame.show();
    }

    private void init() {
        this.helpFrame = new JFrame("Quick Reference Manual");
        Container container = this.helpFrame.getContentPane();
        container.setLayout(new BorderLayout());
        JEditorPane jEditorPane = new JEditorPane();
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        jEditorPane.setBorder(emptyBorder);
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setPreferredSize(new Dimension(400, 450));
        String string = this.getAboutHtml();
        jEditorPane.setText(string);
        jEditorPane.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        container.add((Component)jScrollPane, "Center");
        this.helpFrame.pack();
    }

    private String getAboutHtml() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TABLE WIDTH=100%><TR BGCOLOR=#DDDDDD><TD>");
        stringBuffer.append("<FONT FACE=ARIAL SIZE=+1>");
        stringBuffer.append("Quick Reference Manual");
        stringBuffer.append("</FONT>");
        stringBuffer.append("</TD></TR></TABLE>");
        stringBuffer.append("<FONT FACE=ARIAL>");
        stringBuffer.append("<P><U>About cPath</U>");
        stringBuffer.append("<P>cPath aims to be a freely available cancer pathway database. Currently, only information about protein-protein interactions collected from major interaction databases that support the PSI-MI format is available. cPath is open-source and is easy to locally install for private management of protein-protein interactions. Future directions include support for the BioPAX format so that entire pathways can be stored, queried and presented.<P>cPath is currently being developed by the Computational Biology Center of Memorial Sloan-Kettering Cancer Center.<P>cPath is available at http://www.cbio.mskcc.org/cpath/");
        stringBuffer.append("<P><U>About the cPath PlugIn</U>");
        stringBuffer.append("<P>The cPath PlugIn provides interactive access to the cPath database. Cytoscape users can query cPath, download matching interactions and view them within Cytoscape.");
        stringBuffer.append("<P><U>Search Examples:</U>");
        stringBuffer.append("<P>dna repair");
        stringBuffer.append("<BR>-- Finds all records that contains the words  dna or repair.");
        stringBuffer.append("<P>dna AND repair");
        stringBuffer.append("<BR>-- Finds all records the contain the words  dna AND repair.");
        stringBuffer.append("<P>dna NOT repair");
        stringBuffer.append("<BR>-- Finds all records that contain the word dna, but do not contain the word repair.");
        stringBuffer.append("<P>\"dna repair\"");
        stringBuffer.append("<BR>-- Finds all records containing the exact  text:  \"dna repair\".");
        stringBuffer.append("<P>regulat*");
        stringBuffer.append("<BR>-- Finds all records begin with the wildcard:   \"regulat\". This will match against records, such as regulate, regulatory, etc.");
        stringBuffer.append("<P><U>Advanced Search:  Field Specific Options</U>\n<P>It is possible to restrict your search terms within a query to the following fields:<P>-- interactor: interactor name or external reference.<BR>-- organism: organism name or NCBI taxonomy identifier.<BR>-- pmid: Pub Med Identifier<BR>-- experiment_type: Experiment type<BR>-- database: database source<BR>");
        stringBuffer.append("<BR>For example:");
        stringBuffer.append("<P> pmid:9421503");
        stringBuffer.append("<BR>-- Finds all records associated with pmid:  9421503.");
        stringBuffer.append("<P> database:DIP");
        stringBuffer.append("<BR>-- Finds all records from DIP (Database of Interacting Proteins).");
        stringBuffer.append("</FONT>");
        stringBuffer.append("<P><HR><FONT FACE=ARIAL SIZE=-1>");
        stringBuffer.append("Copyright \u00a9 2004 Memorial Sloan-Kettering Cancer Center.");
        stringBuffer.append("</FONT>");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        QuickReferenceDialog quickReferenceDialog = new QuickReferenceDialog(null);
    }
}

