/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.live.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.live.DataServiceBase;
import org.mskcc.dataservices.services.AliasToGiMapper;

public class LocalAliasToGiMapper
extends DataServiceBase
implements AliasToGiMapper {
    private static HashMap aliasToGiMap;

    public Integer getGI(String string) throws DataServiceException {
        if (aliasToGiMap == null) {
            this.retrieveData();
        }
        String string2 = (String)aliasToGiMap.get(string);
        return new Integer(Integer.parseInt(string2));
    }

    private void retrieveData() throws DataServiceException {
        aliasToGiMap = new HashMap();
        try {
            URLClassLoader uRLClassLoader = (URLClassLoader)this.getClass().getClassLoader();
            URL uRL = uRLClassLoader.findResource(this.getLocation());
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = bufferedReader.readLine();
            while (string != null) {
                this.extractTokens(string);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            String string = "Network error occurred while trying to to retrieve your Alias file:  " + this.getLocation() + ".  Please check your server and network settings, " + "and try again.";
            throw new DataServiceException(iOException, string);
        }
    }

    private void extractTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        String string2 = (String)stringTokenizer.nextElement();
        string2 = string2.toUpperCase();
        String string3 = (String)stringTokenizer.nextElement();
        aliasToGiMap.put(string2, string3);
    }
}

