/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.test.protocol;

import junit.framework.TestCase;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.protocol.CPathProtocol;

public class TestCPathProtocol
extends TestCase {
    public void testValidRequest() throws Exception {
        CPathProtocol cPathProtocol = this.createCbioService("http://localhost:8080/cpath/webservice.do", "protein");
        String string = cPathProtocol.connect();
        int n = string.indexOf("60 kDa chaperonin (Protein Cpn60)");
        TestCPathProtocol.assertTrue((n > 0 ? 1 : 0) != 0);
    }

    public void testInvalidRequest1() throws Exception {
        CPathProtocol cPathProtocol = this.createCbioService("http://localhost:8080/cpath/webservice.do", "SANDER_GENE");
        try {
            cPathProtocol.connect();
            TestCPathProtocol.fail((String)"DataServiceException should have been thrown.");
        }
        catch (DataServiceException dataServiceException) {
            String string = dataServiceException.getMessage();
            TestCPathProtocol.assertTrue((string.length() > 0 ? 1 : 0) != 0);
        }
    }

    public void testCountOnlyRequest() throws Exception {
        CPathProtocol cPathProtocol = this.createCbioService("http://localhost:8080/cpath/webservice.do", "protein");
        cPathProtocol.setFormat("count_only");
        String string = cPathProtocol.connect();
        int n = Integer.parseInt(string);
        TestCPathProtocol.assertTrue((n > 0 ? 1 : 0) != 0);
    }

    private CPathProtocol createCbioService(String string, String string2) {
        CPathProtocol cPathProtocol = new CPathProtocol(string);
        cPathProtocol.setCommand("get_by_keyword");
        cPathProtocol.setFormat("xml");
        cPathProtocol.setQuery(string2);
        return cPathProtocol;
    }
}

