/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of SMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package smt.iter.prec;

import mt.AbstractMatrix;
import mt.Matrix;
import mt.Vector;

/**
 * Combined matrix and preconditioner. Can be used to compute parts of the
 * spectrum of a preconditioned operator. Should not be used in other cases.
 */
public class PreconditionedMatrix extends AbstractMatrix {

	/**
	 * Preconditioner
	 */
	private Preconditioner M;

	/**
	 * And the matrix
	 */
	private Matrix A;

	/**
	 * Constructor for PreconditionedMatrix
	 * 
	 * @param A
	 *            Underlying matrix
	 * @param M
	 *            Preconditioner for the given matrix
	 */
	public PreconditionedMatrix(Matrix A, Preconditioner M) {
		super(A);
		this.A = A;
		this.M = M;
	}

	public Vector multAdd(
		double alpha,
		Vector x,
		double beta,
		Vector y,
		Vector z) {

		// z = M*A*x
		A.mult(x, z);
		M.apply(z, z);

		// z = alpha*z + beta*y
		return z.add(beta, y, alpha);
	}

}
