/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import mt.LowerSymmDenseMatrix;
import mt.UpperSymmDenseMatrix;
import mt.fact.NotConvergedException;
import mt.fact.SymmDenseEigenvalueComputer;
import mt.fact.SymmEigenvalueDecomposition;
import mt.ll.BLASkernel.UpLo;

/**
 * Test of the symmetric, dense eigenvalue solver
 */
public class SymmDenseEigenvalueTest extends SymmEigenvalueTest {

	private LowerSymmDenseMatrix L;

	private UpperSymmDenseMatrix U;

	public SymmDenseEigenvalueTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		super.setUp();
		L = new LowerSymmDenseMatrix(A);
		U = new UpperSymmDenseMatrix(A);
	}

	protected void tearDown() throws Exception {
		super.tearDown();
		L = null;
		U = null;
	}

	public void testLowerStaticFactorize() throws NotConvergedException {
		assertEquals(L, SymmDenseEigenvalueComputer.factorize(L.copy()));
	}

	public void testLowerRepeatStaticFactorize() throws NotConvergedException {
		assertEquals(L, SymmDenseEigenvalueComputer.factorize(L.copy()));
		assertEquals(L, SymmDenseEigenvalueComputer.factorize(L.copy()));
	}

	public void testUpperStaticFactorize() throws NotConvergedException {
		assertEquals(U, SymmDenseEigenvalueComputer.factorize(U.copy()));
	}

	public void testUpperRepeatStaticFactorize() throws NotConvergedException {
		assertEquals(U, SymmDenseEigenvalueComputer.factorize(U.copy()));
		assertEquals(U, SymmDenseEigenvalueComputer.factorize(U.copy()));
	}

	public void testLowerFactor() throws NotConvergedException {
		SymmDenseEigenvalueComputer ec =
			new SymmDenseEigenvalueComputer(A.numRows(), UpLo.Lower);
		assertEquals(L, ec.factor((LowerSymmDenseMatrix)L.copy()));
	}

	public void testUpperFactor() throws NotConvergedException {
		SymmDenseEigenvalueComputer ec =
			new SymmDenseEigenvalueComputer(A.numRows(), UpLo.Upper);
		assertEquals(U, ec.factor((UpperSymmDenseMatrix)U.copy()));
	}

	public void testLowerRepeatFactor() throws NotConvergedException {
		SymmDenseEigenvalueComputer ec =
			new SymmDenseEigenvalueComputer(A.numRows(), UpLo.Lower);
		SymmEigenvalueDecomposition evd = ec.factor((LowerSymmDenseMatrix)L.copy());
		assertEquals(L, evd);
		evd = ec.factor((LowerSymmDenseMatrix)L.copy(), evd);
		assertEquals(L, evd);
	}

	public void testUpperRepeatFactor() throws NotConvergedException {
		SymmDenseEigenvalueComputer ec =
			new SymmDenseEigenvalueComputer(A.numRows(), UpLo.Upper);
		SymmEigenvalueDecomposition evd = ec.factor((UpperSymmDenseMatrix)U.copy());
		assertEquals(U, evd);
		evd = ec.factor((UpperSymmDenseMatrix)U.copy(), evd);
		assertEquals(U, evd);
	}

}
