/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of SMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package smt.iter.eig;

import mt.Matrix;
import mt.Vector;

/**
 * Does not shift the eigenvalue spectrum. The operator is <code>A*x</code>
 */
public class NoEigenvalueTransformation implements EigenvalueTransformation {

	public Vector apply(Matrix A, Vector x, Vector y) {
		return A.mult(x, y);
	}

	public void setShift(double sigma) {
	}

	public double getShift() {
		return 0;
	}

	public double eigenvalue(double e) {
		return e;
	}

}
