/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of SMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package smt.test;

import mt.fact.SymmDenseEigenvalueComputer;
import mt.fact.SymmEigenvalueDecomposition;
import mt.test.Utilities;
import smt.CompRowMatrix;

/**
 * Test of iterative solvers for SPD matrices
 */
public abstract class SPDIterativeSolverTest extends IterativeSolverTest {

	public SPDIterativeSolverTest(String arg0) {
		super(arg0);
	}

	protected void createMatrix() throws Exception {
		// Create a symmetrical matrix
		int n = Utilities.getInt(max), m = Utilities.getInt(Math.min(bmax, n));
		A = new CompRowMatrix(n, n, m);
		Utilities.symmetryPopulate(A, m);

		// Need positive eigenvalues
		A.addDiagonal(shift);
		SymmEigenvalueDecomposition evd =
			SymmDenseEigenvalueComputer.factorize(A);
		while (n > 0 && evd.getEigenvalues()[0] <= 0) {
			A.addDiagonal(shift);
			evd = SymmDenseEigenvalueComputer.factorize(A);
		}
	}

}
