/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of MT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package mt.test;

import mt.SymmTridiagMatrix;
import mt.fact.NotConvergedException;
import mt.fact.SymmEigenvalueDecomposition;
import mt.fact.SymmTridiagEigenvalueComputer;
import mt.util.Matrices;

/**
 * Test of the symmetric, tridiagonal eigenvalue solver
 */
public class SymmTridiagEigenvalueTest extends SymmEigenvalueTest {

	private SymmTridiagMatrix T;

	private final int max = 100;

	public SymmTridiagEigenvalueTest(String arg0) {
		super(arg0);
	}

	protected void setUp() throws Exception {
		int n = Math.max(1, Utilities.getInt(max));
		A = Matrices.random(n, n);
		T = new SymmTridiagMatrix(A);
	}

	protected void tearDown() throws Exception {
		T = null;
	}

	public void testStaticFactorize() throws NotConvergedException {
		assertEquals(T, SymmTridiagEigenvalueComputer.factorize(A));
	}

	public void testRepeatStaticFactorize() throws NotConvergedException {
		assertEquals(T, SymmTridiagEigenvalueComputer.factorize(A));
		assertEquals(T, SymmTridiagEigenvalueComputer.factorize(A));
	}

	public void testFactor() throws NotConvergedException {
		SymmTridiagEigenvalueComputer ec =
			new SymmTridiagEigenvalueComputer(A.numRows());
		assertEquals(T, ec.factor((SymmTridiagMatrix)T.copy()));
	}

	public void testRepeatFactor() throws NotConvergedException {
		SymmTridiagEigenvalueComputer ec =
			new SymmTridiagEigenvalueComputer(A.numRows());
		SymmEigenvalueDecomposition evd = ec.factor((SymmTridiagMatrix)T.copy());
		assertEquals(T, evd);
		evd = ec.factor((SymmTridiagMatrix)T.copy(), evd);
		assertEquals(T, evd);
	}

}
