package org.baderlab.brain;

import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.DistributionFactory;

import java.io.File;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Iterator;

/**
 * Created by IntelliJ IDEA.
 * User: shirleyhui
 * Date: Apr 9, 2009
 * Time: 10:06:16 PM
 * To change this template use File | Settings | File Templates.
 */
public class BindingPWM
{
    private SimpleWeightMatrix matrix;   // position weight matrix
    private String name;                 // name of the protein

    /**
     * Constructor
     */
    public BindingPWM()
    {
    }
    /**
     * Set the name of the protein
     */
    public void setName(String name)
    {
        this.name = name;
    }
    /**
     * Set the position weight matrix
     */
    public void setWeightMatrix(SimpleWeightMatrix matrix)
    {
        this.matrix = matrix;
    }
    /**
     * Get the name of the protein
     */
    public String getName()
    {
        return name;

    }
    /**
     * Get the position weight matrix
     */
    public SimpleWeightMatrix getWeightMatrix()
    {
        return matrix;
    }

    /**
     * Read in the position weight matrix from a file
     */
    public void read(File matrixFile, FiniteAlphabet alpha)
    {
        try
        {
            BufferedReader br = new BufferedReader(new FileReader(matrixFile));
            // First line is the name
            String line =br.readLine();
            String[] splitLine = line.split("\\s+");
            name = splitLine[0];

            HashMap alphaWeightHashMap = new HashMap();
            while((line=br.readLine())!= null)
            {
                splitLine = line.split("\\s+");
                String aa = splitLine[0];
                double[] weights = new double[splitLine.length-1];
                for (int i = 1 ; i < splitLine.length;i++)
                {
                    weights[i-1] = Double.parseDouble(splitLine[i]);
                }
                alphaWeightHashMap.put(aa,weights);
            }

            int numPositions = splitLine.length-1;
            Distribution[] dists = new Distribution[numPositions];
            // Update weights
            // For each position
            for (int i = 0; i < numPositions ; i++)
            {
                // Create empty default distribution
                Distribution dist = DistributionFactory.DEFAULT.createDistribution(alpha);

                // For each aa
                Iterator it = alpha.iterator();
                SymbolTokenization st = null;
                try {
                    st = ProteinTools.getAlphabet().getTokenization("token");
                } catch (BioException e) {
                    System.err.println("Unable to get symboltokenization. This should never happen.");
                }
                while(it.hasNext())
                {
                    Symbol symbol = (Symbol)it.next();

                    String symbolName = st.tokenizeSymbol(symbol);
                    //String symbolName = symbol.getName();
                    //System.out.println("Looking up "+ symbolName);
                    double[] weights = (double[])alphaWeightHashMap.get(symbolName);
                    if (weights == null)
                    {
                        //System.out.println("weights are null");
                        dist.setWeight(symbol, 0.0);
                    }
                    else
                        dist.setWeight(symbol, weights[i]);
                    //System.out.println(symbol.getName() + "=" + dist.getWeight(symbol));
                }
                dists[i] = dist;
            }

            matrix = new SimpleWeightMatrix(dists);
            //System.out.println("End");
        }
        catch(Exception e)
        {
            System.out.println("Exception: " + e);
            e.printStackTrace();
        }
    }


}
