package org.baderlab.brain.correlationlearn;


/**
 * Copyright (c) 2005 Memorial Sloan-Kettering Cancer Center
 *
 * Code written by: Gary Bader
 * Authors: Gary Bader, Chris Sander
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2.1 of the License, or
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY, WITHOUT EVEN THE IMPLIED WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * documentation provided hereunder is on an "as is" basis, and
 * Memorial Sloan-Kettering Cancer Center
 * has no obligations to provide maintenance, support,
 * updates, enhancements or modifications.  In no event shall the
 * Memorial Sloan-Kettering Cancer Center
 * be liable to any party for direct, indirect, special,
 * incidental or consequential damages, including lost profits, arising
 * out of the use of this software and its documentation, even if
 * Memorial Sloan-Kettering Cancer Center
 * has been advised of the possibility of such damage.  See
 * the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 * User: shirleyhui
 * Date: Jul 16, 2007
 * Time: 1:42:19 PM
 */

/**
 * Stores a single feature that we learn from (position, residue pair)
 */
public class ResiduePositionPair implements Comparable {

    /**
     * The amino acid residue
     */
    public char residue;

    /**
     * The position of the residue in the alignment (positions starts at 0)
     */
    public int position;

    /**
     * Constructor for a residue position pair
     * @param position The position of the residue in the alignment (positions starts at 0)
     * @param residue The amino acid residue
     */
    public ResiduePositionPair(int position, char residue) {
        this.position = position;
        this.residue = residue;
    }

    /**
     * Returns a string representation of this object
     * @return The string representation of this object
     */
    public String toString() {
        return new String("(" + residue + "@" + position + ")");
    }

    /**
     * Returns true if this ResiduePosition pair is equal to compareTo, otherwise false
     * @param compareTo The ResiduePositionPair object to compare this one to
     * @return true if this ResiduePosition pair is equal to compareTo, otherwise false
     */
    public boolean equals(Object compareTo)
    {
        ResiduePositionPair pair = (ResiduePositionPair)compareTo;
        return (pair.residue == this.residue);
    }

    /**
     * Returns a -1 if this position is less than the object's position, a 1 if this position is greater than the
     * object's position.  If the positions are equal, a zero is returned if the residues are the same, a -1 is
     * returned if this residue is less than the object's residue, a 1 if this residue is greater than the object's
     * residue.
     * @param o The object to compare this object to
     * @return -1 if less than, 1 if greater than, 0 if equal
     */
    public int compareTo(Object o)
    {
        int comp = -200;
        ResiduePositionPair pair = (ResiduePositionPair)o;
        //System.out.print("Comparing: this, " + this.toString() + " and other, " + pair.toString());
        if (this.position < pair.position)
        {
            comp = -1;
        }

        if (this.position == pair.position)
        {
            if (this.residue == pair.residue)
            {
                comp = 0;
            } else if (this.residue < pair.residue)
            {
                comp = -1;
            }
            else
            {
                comp = 1;
            }

        }

        if (this.position > pair.position)
        {
            comp = 1;
        }

        //System.out.println("Comparison is : " + comp);
        return comp;
    }
}
