package org.baderlab.brain;

import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

import java.awt.*;
import java.util.ArrayList;

/**
 * Created by IntelliJ IDEA.
 * User: moyez
 * Date: Jul 24, 2007
 * Time: 6:45:54 PM
 * To change this template use File | Settings | File Templates.
 */

/**
 * Copyright (c) 2005 Memorial Sloan-Kettering Cancer Center
 * *
 * * Code written by: Gary Bader
 * * Authors: Gary Bader, Chris Sander
 * *
 * * This library is free software; you can redistribute it and/or modify it
 * * under the terms of the GNU Lesser General Public License as published
 * * by the Free Software Foundation; either version 2.1 of the License, or
 * * any later version.
 * *
 * * This library is distributed in the hope that it will be useful, but
 * * WITHOUT ANY WARRANTY, WITHOUT EVEN THE IMPLIED WARRANTY OF
 * * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  The software and
 * * documentation provided hereunder is on an "as is" basis, and
 * * Memorial Sloan-Kettering Cancer Center
 * * has no obligations to provide maintenance, support,
 * * updates, enhancements or modifications.  In no event shall the
 * * Memorial Sloan-Kettering Cancer Center
 * * be liable to any party for direct, indirect, special,
 * * incidental or consequential damages, including lost profits, arising
 * * out of the use of this software and its documentation, even if
 * * Memorial Sloan-Kettering Cancer Center
 * * has been advised of the possibility of such damage.  See
 * * the GNU Lesser General Public License for more details.
 * *
 * * You should have received a copy of the GNU Lesser General Public License
 * * along with this library; if not, write to the Free Software Foundation,
 * * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * *
 * * User: GaryBader
 * * Date: Feb 23, 2006
 * * Time: 10:54:02 PM
 */

public class PDZProteinLogoStyle implements SymbolStyle {
    private ArrayList<Color> colorList;

/**
 * Paints colors for the sequence logo according to PDZ 2007
 * This coloring was developed by Sachdev Sidhu
 */

    public PDZProteinLogoStyle() {
        AminoAcidGrouping aaGroup = new AminoAcidGrouping();
        aaGroup.setColoring(AminoAcidGrouping.COLORING_PDZ);
        this.colorList = aaGroup.getColorList();
    }

    public PDZProteinLogoStyle(ArrayList<Color> colorList) {
        this.colorList = colorList;
    }

    public Paint outlinePaint(Symbol s) throws IllegalSymbolException {
        return fillPaint(s);
    }

    public Paint fillPaint(Symbol s) throws IllegalSymbolException {
        Paint fillColor = null;

        //(STQN) are green
        if (s.equals(ProteinTools.s()) || s.equals(ProteinTools.t()) || s.equals(ProteinTools.q()) ||
                s.equals(ProteinTools.n())) {
            fillColor = colorList.get(0);

        //acidic/amide (DE) red
        } else if (s.equals(ProteinTools.d()) || s.equals(ProteinTools.e())) {
            fillColor = colorList.get(1);

        //basic (KRH) blue
        } else if (s.equals(ProteinTools.k()) || s.equals(ProteinTools.r()) || s.equals(ProteinTools.h())) {
            fillColor = colorList.get(2);

        } else if (s.equals(ProteinTools.g())) {
            fillColor = colorList.get(3);

        } else if (s.equals(ProteinTools.c())) {
            fillColor = colorList.get(4);

        } else if (s.equals(ProteinTools.p())) {
            fillColor = colorList.get(5);

        //hydrophobic (A,V,L,I,M,FYW) amino acids are black
        } else {
            fillColor = colorList.get(6);
        }
        
        return fillColor;
    }
}
