import sys
import os
import math
import tarfile

def load_surface(path):
    '''
    Read surafec accessibility data generated by SABLE2
    '''

    tar =\
        tarfile.open(path + "/surface.tar.gz", "r:gz")
    data = {}
    for tarinfo in tar:
        if tarinfo.isfile():
            file_data = tar.extractfile(tarinfo).readlines()
            seq = ''
            flg = 0
            pid = tarinfo.name.strip("yeast/")
            for line in range(len(file_data)):
                if file_data[line].startswith("Relative solvent accessibility prediction"):
                    flg = 1
                if flg:
                    if file_data[line].startswith(">"):
                        seq += file_data[line + 2].strip()
                    if file_data[line].startswith("END_SECTION"):
                        flg = 0
            data[pid] = map(int, list(seq))
    return data


def surface_score(pid, stat, stop, data, pos):
    '''
    Average of surface accessibility scores.
    score : RSA
    0 : 0-9%
    1 : 10-19%
    2 : 20-29%
    9 : 90-100%
    '''

    if pid in data:
        regn = data[pid][stat : stop]
        #print regn
        if len(regn) == 0:
            return None
        else:
            #val1 = (sum(regn) / float(len(regn))) / 9
            sum_resd = 0.0
            for idx, value in enumerate(regn):
                if idx in pos:
                    if value >= 2:
                        # sum_resd += float(value)
                        sum_resd += 1
            # val = sum_resd / float(len(pos)) / 9
            val = sum_resd / float(len(pos))
            return val

    else:
        return None



if __name__ == "__main__":
    os.environ["WORK_DIR_GEN"] = "../../"
    data = read_surface()
    print len(data)
   #print surface_score("ENSP00000351507", 0, 3, data)




