/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers;

import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeList {
    CyNetwork network;
    boolean nodesOnly = false;
    @Tunable(description="Node attributes for cluster", groups={"Array sources"}, tooltip="You must choose at least 2 node columns for an attribute cluster", gravity=50.0)
    public ListMultipleSelection<String> nodeAttributeList = null;
    @Tunable(description="Edge column for cluster", groups={"Array sources"}, tooltip="You may only chose 1 edge column for an attribute cluster", gravity=51.0)
    public ListSingleSelection<String> edgeAttributeList = null;

    public AttributeList(CyNetwork network) {
        this(network, false);
    }

    public AttributeList(CyNetwork network, boolean nodesOnly) {
        this.network = network;
        if (network != null) {
            this.nodeAttributeList = ModelUtils.updateNodeAttributeList(network, this.nodeAttributeList);
            if (!nodesOnly) {
                this.edgeAttributeList = ModelUtils.updateEdgeAttributeList(network, this.edgeAttributeList);
            }
        }
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        this.nodeAttributeList = ModelUtils.updateNodeAttributeList(network, this.nodeAttributeList);
        if (!this.nodesOnly) {
            this.edgeAttributeList = ModelUtils.updateEdgeAttributeList(network, this.edgeAttributeList);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public List<String> getNodeAttributeList() {
        if (this.nodeAttributeList == null) {
            return null;
        }
        List attrs = this.nodeAttributeList.getSelectedValues();
        if (attrs == null || attrs.size() == 0) {
            return null;
        }
        if (attrs.size() == 1 && ((String)attrs.get(0)).equals("--None--")) {
            return null;
        }
        return attrs;
    }

    public String getEdgeAttribute() {
        if (this.edgeAttributeList == null) {
            return null;
        }
        String attr = (String)this.edgeAttributeList.getSelectedValue();
        if (attr == null || attr.equals("--None--")) {
            return null;
        }
        return attr;
    }
}

