/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.ChengChurch;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AbstractAttributeClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.ChengChurch.ChengChurchContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.ChengChurch.RunChengChurch;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.BiclusterView;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.group.CyGroup;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChengChurch
extends AbstractAttributeClusterer {
    public static String SHORTNAME = "cheng&church";
    public static String NAME = "Cheng & Church's  bi-cluster";
    public static final String GROUP_ATTRIBUTE = SHORTNAME + "Groups.SUID";
    CyTableManager tableManager = null;
    private CyTableFactory tableFactory = null;
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public ChengChurchContext context = null;

    public ChengChurch(ChengChurchContext context, ClusterManager clusterManager) {
        super(clusterManager);
        this.context = context;
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
        this.tableManager = clusterManager.getTableManager();
        this.tableFactory = clusterManager.getTableFactory();
    }

    @Override
    public String getShortName() {
        return SHORTNAME;
    }

    @Override
    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public ClusterViz getVisualizer() {
        return null;
    }

    public void run(TaskMonitor monitor) {
        String[] attributeArray;
        this.monitor = monitor;
        monitor.setTitle("Performing " + this.getName());
        List<String> nodeAttributeList = this.context.attributeList.getNodeAttributeList();
        String edgeAttribute = this.context.attributeList.getEdgeAttribute();
        this.clusterAttributeName = "CnC_Bicluster";
        if (this.network.getRow((CyIdentifiable)this.network, "LOCAL_ATTRS").getTable().getColumn("__clusterAttribute") == null) {
            this.network.getRow((CyIdentifiable)this.network, "LOCAL_ATTRS").getTable().createColumn("__clusterAttribute", String.class, false);
        }
        this.network.getRow((CyIdentifiable)this.network, "LOCAL_ATTRS").set("__clusterAttribute", (Object)this.clusterAttributeName);
        if (nodeAttributeList == null && edgeAttribute == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must select either one edge column or two or more node columns");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() > 0 && edgeAttribute != null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't have both node and edge columns selected");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() < 2) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least two node columns for cluster weighting");
            return;
        }
        if (this.context.selectedOnly && CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true).size() < 3) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least three nodes to cluster");
            return;
        }
        this.createGroups = this.context.createGroups;
        Collections.sort(nodeAttributeList);
        if (nodeAttributeList != null && nodeAttributeList.size() > 1) {
            attributeArray = new String[nodeAttributeList.size()];
            int i = 0;
            for (String attr : nodeAttributeList) {
                attributeArray[i++] = "node." + attr;
            }
        } else {
            attributeArray = new String[]{"edge." + edgeAttribute};
        }
        monitor.setStatusMessage("Initializing");
        this.resetAttributes(this.network, GROUP_ATTRIBUTE);
        RunChengChurch algorithm = new RunChengChurch(this.network, attributeArray, monitor, this.context);
        String resultsString = "ChengChurch results:";
        monitor.setStatusMessage("Clustering nodes");
        Integer[] rowOrder = algorithm.cluster(false);
        Matrix biclusterMatrix = algorithm.getBiclusterMatrix();
        int[] clusters = new int[biclusterMatrix.nRows()];
        this.createGroups(this.network, biclusterMatrix, 1, clusters, "cheng&hurch");
        this.updateAttributes(this.network, GROUP_ATTRIBUTE, rowOrder, attributeArray, this.getAttributeList(), algorithm.getBiclusterMatrix());
        this.createBiclusterTable(algorithm.getClusterNodes(), algorithm.getClusterAttrs());
        if (this.context.showUI) {
            this.insertTasksAfterCurrentTask(new Task[]{new BiclusterView(this.clusterManager)});
        }
    }

    protected void createBiclusterGroups(Map<Integer, List<Long>> clusterNodes) {
        ArrayList clusterList = new ArrayList();
        ArrayList<Long> groupList = new ArrayList<Long>();
        this.createGroups = this.context.createGroups;
        this.attrList = new ArrayList();
        for (Integer bicluster : clusterNodes.keySet()) {
            CyGroup group;
            String groupName = this.clusterAttributeName + "_" + bicluster;
            List<Long> suidList = clusterNodes.get(bicluster);
            ArrayList<CyNode> nodeList = new ArrayList<CyNode>();
            for (Long suid : suidList) {
                CyNode node = this.network.getNode(suid.longValue());
                this.attrList.add((String)this.network.getRow((CyIdentifiable)node).get("name", String.class) + "\t" + bicluster);
                nodeList.add(node);
            }
            if (!this.createGroups || (group = this.clusterManager.createGroup(this.network, groupName, nodeList, null, true)) == null) continue;
            groupList.add(group.getGroupNode().getSUID());
        }
        ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.network, GROUP_ATTRIBUTE, groupList, List.class, Long.class);
        ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.network, "__clusterType", this.getShortName(), String.class, null);
        ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.network, "__clusterAttribute", this.clusterAttributeName, String.class, null);
        if (this.params != null) {
            ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.network, "__clusterParams", this.params, List.class, String.class);
        }
    }

    public void createBiclusterTable(Map<Integer, List<Long>> clusterNodes, Map<Integer, List<String>> clusterAttrs) {
        CyRow TableRow;
        long BiClusterTableSUID;
        CyTable networkTable = this.network.getTable(CyNetwork.class, "LOCAL_ATTRS");
        CyTable BiClusterNodeTable = null;
        CyTable BiClusterAttrTable = null;
        if (!CyTableUtil.getColumnNames((CyTable)networkTable).contains(this.clusterAttributeName + "_NodeTable.SUID")) {
            this.network.getDefaultNetworkTable().createColumn(this.clusterAttributeName + "_NodeTable.SUID", Long.class, false);
            BiClusterNodeTable = this.tableFactory.createTable(this.clusterAttributeName + "_NodeTable", "Node.SUID", Long.class, true, true);
            BiClusterNodeTable.createListColumn("Bicluster List", Integer.class, false);
        } else {
            BiClusterTableSUID = (Long)this.network.getRow((CyIdentifiable)this.network).get(this.clusterAttributeName + "_NodeTable.SUID", Long.class);
            BiClusterNodeTable = this.tableManager.getTable(BiClusterTableSUID);
        }
        if (!CyTableUtil.getColumnNames((CyTable)networkTable).contains(this.clusterAttributeName + "_AttrTable.SUID")) {
            this.network.getDefaultNetworkTable().createColumn(this.clusterAttributeName + "_AttrTable.SUID", Long.class, false);
            BiClusterAttrTable = this.tableFactory.createTable(this.clusterAttributeName + "_AttrTable", "BiCluster Number", Integer.class, true, true);
            BiClusterAttrTable.createListColumn("Bicluster Attribute List", String.class, false);
        } else {
            BiClusterTableSUID = (Long)this.network.getRow((CyIdentifiable)this.network).get(this.clusterAttributeName + "_AttrTable.SUID", Long.class);
            BiClusterAttrTable = this.tableManager.getTable(BiClusterTableSUID);
        }
        HashMap biclusterList = new HashMap();
        for (Integer clust : clusterNodes.keySet()) {
            List<Long> temp = clusterNodes.get(clust);
            for (Long node : temp) {
                if (biclusterList.containsKey(node)) {
                    ((List)biclusterList.get(node)).add(clust);
                    continue;
                }
                ArrayList<Integer> newlist = new ArrayList<Integer>();
                newlist.add(clust);
                biclusterList.put(node, newlist);
            }
        }
        for (Long node : biclusterList.keySet()) {
            TableRow = BiClusterNodeTable.getRow((Object)node);
            TableRow.set("Bicluster List", biclusterList.get(node));
        }
        for (Integer clust : clusterAttrs.keySet()) {
            TableRow = BiClusterAttrTable.getRow((Object)clust);
            TableRow.set("Bicluster Attribute List", clusterAttrs.get(clust));
        }
        this.network.getRow((CyIdentifiable)this.network).set(this.clusterAttributeName + "_NodeTable.SUID", (Object)BiClusterNodeTable.getSUID());
        this.network.getRow((CyIdentifiable)this.network).set(this.clusterAttributeName + "_AttrTable.SUID", (Object)BiClusterAttrTable.getSUID());
        this.tableManager.addTable(BiClusterNodeTable);
        this.tableManager.addTable(BiClusterAttrTable);
    }
}

