/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DBSCAN;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AbstractAttributeClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DBSCAN.DBSCANContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DBSCAN.RunDBSCAN;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.KnnView;
import java.util.Collections;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class DBSCAN
extends AbstractAttributeClusterer {
    public static String SHORTNAME = "dbscan";
    public static String NAME = "DBSCAN cluster";
    public static String GROUP_ATTRIBUTE = SHORTNAME;
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public DBSCANContext context = null;

    public DBSCAN(DBSCANContext context, ClusterManager clusterManager) {
        super(clusterManager);
        this.context = context;
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
    }

    public String getShortName() {
        return SHORTNAME;
    }

    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public ClusterViz getVisualizer() {
        return null;
    }

    public void run(TaskMonitor monitor) {
        Integer[] rowOrder;
        int[] clusters;
        String[] attributeArray;
        this.monitor = monitor;
        monitor.setTitle("Performing " + this.getName());
        List<String> nodeAttributeList = this.context.attributeList.getNodeAttributeList();
        String edgeAttribute = this.context.attributeList.getEdgeAttribute();
        if (nodeAttributeList == null && edgeAttribute == null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must select either one edge column or two or more node columns");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() > 0 && edgeAttribute != null) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Can't have both node and edge columns selected");
            return;
        }
        if (nodeAttributeList != null && nodeAttributeList.size() < 2) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least two node columns for cluster weighting");
            return;
        }
        if (this.context.selectedOnly && CyTableUtil.getNodesInState((CyNetwork)this.network, (String)"selected", (boolean)true).size() < 3) {
            monitor.showMessage(TaskMonitor.Level.ERROR, "Must have at least three nodes to cluster");
            return;
        }
        this.createGroups = this.context.createGroups;
        Collections.sort(nodeAttributeList);
        if (nodeAttributeList != null && nodeAttributeList.size() > 1) {
            attributeArray = new String[nodeAttributeList.size()];
            int i = 0;
            for (String attr : nodeAttributeList) {
                attributeArray[i++] = "node." + attr;
            }
        } else {
            attributeArray = new String[]{"edge." + edgeAttribute};
        }
        monitor.setStatusMessage("Initializing");
        this.resetAttributes(this.network, GROUP_ATTRIBUTE);
        this.distanceMetric = this.context.getDistanceMetric();
        RunDBSCAN algorithm = new RunDBSCAN(this.network, attributeArray, this.distanceMetric, monitor, this.context);
        String resultsString = "DBSCAN results:";
        if (this.context.clusterAttributes && attributeArray.length > 1) {
            monitor.setStatusMessage("Clustering attributes");
            clusters = algorithm.cluster(true);
            if (!algorithm.getMatrix().isTransposed()) {
                this.createGroups(this.network, algorithm.getMatrix(), algorithm.getNClusters(), clusters, "dbscan");
            }
            rowOrder = algorithm.getMatrix().indexSort(clusters, clusters.length);
            this.updateAttributes(this.network, GROUP_ATTRIBUTE, rowOrder, attributeArray, this.getAttributeList(), algorithm.getMatrix());
        }
        monitor.setStatusMessage("Clustering nodes");
        clusters = algorithm.cluster(false);
        if (!algorithm.getMatrix().isTransposed()) {
            this.createGroups(this.network, algorithm.getMatrix(), algorithm.getNClusters(), clusters, "dbscan");
        }
        rowOrder = algorithm.getMatrix().indexSort(clusters, clusters.length);
        this.updateAttributes(this.network, GROUP_ATTRIBUTE, rowOrder, attributeArray, this.getAttributeList(), algorithm.getMatrix());
        if (this.context.showUI) {
            this.insertTasksAfterCurrentTask(new Task[]{new KnnView(this.clusterManager)});
        }
    }
}

