/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.AutoSOMEContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.RunAutoSOME;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterViz;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.KnnView;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class AutoSOMECluster
extends AbstractNetworkClusterer {
    public static final String GROUP_ATTRIBUTE = "__AutoSOMEGroups.SUID";
    public static final String SHORTNAME = "autosome_heatmap";
    public static final String NAME = "AutoSOME Attribute Clustering";
    public static final String NET_SHORTNAME = "autosome_network";
    public static final String NET_NAME = "AutoSOME Network Clustering";
    private int cluster_output = 0;
    private boolean finishedClustering = false;
    private Settings settings;
    private RunAutoSOME runAutoSOME = null;
    private List<NodeCluster> nodeCluster;
    private List<String> attrList;
    private List<String> attrOrderList;
    private List<String> nodeOrderList;
    private boolean heatmap = true;
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public AutoSOMEContext context = null;

    public AutoSOMECluster(AutoSOMEContext context, ClusterManager clusterManager, boolean heatmap) {
        super(clusterManager);
        this.context = context;
        this.heatmap = heatmap;
        context.numThreads = Runtime.getRuntime().availableProcessors();
        if (this.network == null) {
            this.network = clusterManager.getNetwork();
        }
        context.setNetwork(this.network);
        if (heatmap) {
            context.dataVisualization.setSelectedValue((Object)"Heatmap");
        } else {
            context.dataVisualization.setSelectedValue((Object)"Network");
        }
        this.clusterAttributeName = context.getClusterAttribute();
    }

    public String getShortName() {
        return SHORTNAME;
    }

    @ProvidesTitle
    public String getName() {
        return "AutoSOME " + (this.context.getSettings().distMatrix ? "Fuzzy " : "") + "Clustering";
    }

    public ClusterViz getVisualizer() {
        return null;
    }

    public void run(TaskMonitor monitor) {
        this.monitor = monitor;
        monitor.setTitle("Performing " + this.getName());
        String networkID = ModelUtils.getNetworkName(this.network);
        this.settings = this.context.getSettings();
        if (networkID.contains("--AutoSOME")) {
            String[] tokens = networkID.split("--AutoSOME");
            networkID = tokens[0];
            this.network = ModelUtils.getNetworkWithName(this.clusterManager, networkID);
        }
        List<String> dataAttributes = this.context.attributeList.getNodeAttributeList();
        this.runAutoSOME = new RunAutoSOME(this.clusterManager, dataAttributes, this.network, this.settings, monitor);
        this.runAutoSOME.setIgnoreMissing(this.context.ignoreMissing);
        this.runAutoSOME.setSelectedOnly(this.context.selectedOnly);
        this.runAutoSOME.setDebug(this.debug);
        monitor.setStatusMessage("Running AutoSOME" + (this.settings.distMatrix ? " Fuzzy Clustering" : ""));
        this.nodeCluster = this.runAutoSOME.run(monitor);
        if (this.nodeCluster == null) {
            monitor.setStatusMessage("Clustering failed!");
            return;
        }
        if (this.nodeCluster.size() > 0) {
            this.finishedClustering = true;
        }
        monitor.setStatusMessage("Removing groups");
        this.removeGroups(this.network, this.getShortName());
        monitor.setStatusMessage("Creating groups");
        if (this.settings.distMatrix) {
            this.runAutoSOME.getEdges(this.context.maxEdges);
        }
        this.attrList = this.runAutoSOME.attrList;
        this.attrOrderList = this.runAutoSOME.attrOrderList;
        this.nodeOrderList = this.runAutoSOME.nodeOrderList;
        ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.network, "__nodeClusters", this.attrList, List.class, String.class);
        ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.network, "__arrayOrder", this.attrOrderList, List.class, String.class);
        ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.network, "__nodeOrder", this.nodeOrderList, List.class, String.class);
        ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.network, "__clusterType", this.getShortName(), String.class, null);
        if (!this.settings.distMatrix) {
            List<List<CyNode>> nodeClusters = this.createGroups(this.network, this.nodeCluster, GROUP_ATTRIBUTE);
            AbstractClusterResults results = new AbstractClusterResults(this.network, nodeClusters);
            monitor.setStatusMessage("Done.  AutoSOME results:\n" + results);
            System.out.println("Done.  AutoSOME results:\n" + results);
        } else {
            ArrayList nodeClusters = new ArrayList();
            monitor.setStatusMessage("Done.  AutoSOME results:\n" + this.nodeCluster.size() + " clusters found.");
            System.out.println("Done.  AutoSOME results:\n" + this.nodeCluster.size() + " clusters found.");
        }
        if (this.context.showViz) {
            if (this.heatmap) {
                this.insertTasksAfterCurrentTask(new Task[]{new KnnView(this.clusterManager)});
            } else {
                this.insertTasksAfterCurrentTask(new Task[]{new NewNetworkView(this.network, this.clusterManager, true, false)});
            }
        }
    }

    public void cancel() {
        this.runAutoSOME.cancel();
    }
}

