/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.clustering.mst;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.clustering.mst.Edge;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.clustering.mst.kNode;

public class Kruskal {
    int n;
    int m;
    int u;
    int usel;
    int step;
    kNode[] v = new kNode[100];
    Edge[] e = new Edge[200];
    int[] idx = new int[200];

    int findkNode(int name) {
        for (int i = 0; i < this.n; ++i) {
            if (this.v[i].name != name) continue;
            return i;
        }
        return -1;
    }

    void input_graph(float[] edges, short[][] nodes) {
        int i;
        int kNodeNum = edges.length;
        this.v = new kNode[kNodeNum];
        this.e = new Edge[edges.length];
        this.idx = new int[this.e.length];
        this.n = kNodeNum;
        this.m = edges.length;
        for (i = 0; i < this.n; ++i) {
            kNode kNode2 = new kNode();
            kNode2.name = i;
            this.v[i] = kNode2;
        }
        for (i = 0; i < this.m; ++i) {
            Edge edge = new Edge();
            float dist = edges[i];
            edge.name = i;
            edge.rndd_plus = nodes[i][0];
            edge.rndd_minus = nodes[i][1];
            edge.len = dist;
            this.e[i] = edge;
        }
        for (i = 0; i < this.m; ++i) {
            this.e[i].select = -1;
        }
        this.step1();
        this.step = 2;
        while (this.u < this.m) {
            if (this.step == 3) {
                this.step3();
                this.step = 2;
                continue;
            }
            this.step2();
            this.step = 3;
        }
    }

    void swap(int i, int j) {
        int k = this.idx[i];
        this.idx[i] = this.idx[j];
        this.idx[j] = k;
    }

    int partition(int left, int right) {
        float pivot = this.e[this.idx[(left + right) / 2]].len;
        while (left <= right) {
            while (this.e[this.idx[left]].len < pivot) {
                ++left;
            }
            while (this.e[this.idx[right]].len > pivot) {
                --right;
            }
            if (left > right) continue;
            this.swap(left++, right--);
        }
        return left;
    }

    void qsort(int left, int right) {
        if (left >= right) {
            return;
        }
        int i = this.partition(left, right);
        this.qsort(left, i - 1);
        this.qsort(i, right);
    }

    void step1() {
        int i;
        for (i = 0; i < this.m; ++i) {
            this.idx[i] = i;
        }
        for (i = 0; i < this.m; ++i) {
            this.e[i].select = -1;
        }
        this.qsort(0, this.m - 1);
        for (i = 0; i < this.m; ++i) {
            this.e[i].select = -1;
        }
        for (i = 0; i < this.n; ++i) {
            this.v[i].set = i;
            this.v[i].first = i;
            this.v[i].next = -1;
        }
        this.u = 0;
        this.usel = 0;
    }

    void step2() {
        this.e[this.idx[this.u]].select = 1;
    }

    void step3() {
        int vl = this.e[this.idx[this.u]].rndd_plus;
        short vr = this.e[this.idx[this.u]].rndd_minus;
        if (this.v[vl].set == this.v[vr].set) {
            ++this.u;
            this.e[this.idx[this.u]].select = -2;
            return;
        }
        ++this.usel;
        ++this.u;
        this.e[this.idx[this.u]].select = 2;
        int i = vl;
        while (this.v[i].next >= 0) {
            i = this.v[i].next;
        }
        this.v[i].next = this.v[vr].first;
        int j = this.v[vl].first;
        int k = this.v[vl].set;
        i = this.v[vr].first;
        while (i >= 0) {
            this.v[i].first = j;
            this.v[i].set = k;
            i = this.v[i].next;
        }
    }
}

