/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.clustering.mst;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.clustering.mst.Kruskal;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.Point;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.clusterRun;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JProgressBar;

public class MSTCluster {
    private int nodeNum = 0;
    private double alpha = 0.1;
    private int MCitors = 1;
    private boolean gaussian = false;
    public int[][] rgb;
    private int[] ids;
    public float[][] DEC;
    private double[] BMU;
    private JProgressBar jpb;
    private double[][] randEdges;
    private double[][] edges;
    private int jpbItor = 1;
    private boolean file = false;
    private clusterRun cr;
    private boolean ensemble = false;
    private Settings s;
    private static double threshold = 0.0;

    public MSTCluster(boolean ensemble) {
        this.ensemble = ensemble;
    }

    public void run(JProgressBar jprog, float[][] polygons, ArrayList ids, double alp, int it, boolean gauss, Settings s) {
        this.alpha = alp;
        this.MCitors = it;
        this.jpb = jprog;
        this.gaussian = gauss;
        this.file = this.file;
        this.s = s;
        float[][] coors = this.readPolygons(polygons);
        int[][] data = this.readIDs(ids);
        this.runMST(coors, data);
    }

    private float[][] readPolygons(float[][] poly) {
        float[][] coors = new float[1][1];
        float[][] polyCoors = new float[1][1];
        int points = poly.length;
        int polygons = 4;
        int dimensions = 3;
        coors = new float[points][dimensions];
        polyCoors = new float[polygons][dimensions];
        this.DEC = poly;
        int scale = 36;
        float[][] shorterDEC = new float[this.DEC.length][3];
        for (int h = 0; h < shorterDEC.length; ++h) {
            shorterDEC[h] = this.DEC[h];
        }
        this.DEC = shorterDEC;
        int regionItor = 0;
        int q = 0;
        int itor = 0;
        while (q < points) {
            if (itor == 4) {
                coors[regionItor++] = this.getCentroid(polyCoors);
                polyCoors = new float[polygons][dimensions];
                itor = 0;
            }
            for (int p = 0; p < dimensions; ++p) {
                polyCoors[itor][p] = poly[q][p];
            }
            ++q;
            ++itor;
        }
        coors[regionItor++] = this.getCentroid(polyCoors);
        this.nodeNum = regionItor - 1;
        return coors;
    }

    private float[] getCentroid(float[][] pts) {
        float[] centroid = new float[pts[0].length];
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        float maxZ = -3.4028235E38f;
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        for (int j = 0; j < pts.length; ++j) {
            if (pts[j][0] > maxX) {
                maxX = pts[j][0];
            }
            if (pts[j][1] > maxY) {
                maxY = pts[j][1];
            }
            if (pts[j][2] > maxZ) {
                maxZ = pts[j][2];
            }
            if (pts[j][0] < minX) {
                minX = pts[j][0];
            }
            if (pts[j][1] < minY) {
                minY = pts[j][1];
            }
            if (!(pts[j][2] < minZ)) continue;
            minZ = pts[j][2];
        }
        centroid[0] = (maxX + minX) / 2.0f;
        centroid[1] = (maxY + minY) / 2.0f;
        centroid[2] = (maxZ + minZ) / 2.0f;
        return centroid;
    }

    private int[][] readIDs(ArrayList ids) {
        int[][] data = new int[ids.size()][2];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (int[])ids.get(i);
        }
        return data;
    }

    private void runMST(float[][] coors, int[][] data) {
        ArrayList[] IDs = new ArrayList[coors.length];
        int numNodes = 0;
        for (int j = 0; j < data.length; ++j) {
            if (IDs[data[j][0]] == null) {
                IDs[data[j][0]] = new ArrayList();
                ++numNodes;
            }
            IDs[data[j][0]].add(data[j][1]);
        }
        ArrayList[] idsreduced = new ArrayList[numNodes];
        int i = 0;
        for (int j = 0; j < IDs.length; ++j) {
            if (IDs[j] == null) continue;
            idsreduced[i] = IDs[j];
            ++i;
        }
        Point[] p = new Point[numNodes];
        int j = 0;
        for (i = 0; i < coors.length; ++i) {
            if (IDs[i] == null) continue;
            p[j++] = new Point(coors[i]);
        }
        this.runMSTclustering(p, idsreduced);
    }

    public void runMSTclustering(Point[] p, ArrayList[] idsreduced) {
        this.edges = this.MCST(p);
        double thresh = 0.0;
        this.MonteCarlo(this.edges, p);
        thresh = threshold = this.getPvalue();
        this.cr = new clusterRun(p, this.edges, idsreduced, this.DEC, thresh, this.s.input.length);
    }

    public double[][] MCST(Point[] coors) {
        double[][] edges = new double[coors.length - 1][3];
        float[] e = new float[edges.length + edges.length * edges.length / 2];
        short[][] n = new short[e.length][2];
        int itor = 0;
        for (int i = 0; i < coors.length - 1; ++i) {
            for (int j = i + 1; j < coors.length; ++j) {
                n[itor][0] = (short)i;
                n[itor][1] = (short)j;
                e[itor++] = this.Euc(coors[i].getPoint(), coors[j].getPoint());
            }
        }
        Kruskal k = new Kruskal();
        k.input_graph(e, n);
        int j = 0;
        for (int i = 0; i < k.e.length; ++i) {
            if (k.e[i].select != 2) continue;
            edges[j][0] = k.e[i].rndd_plus;
            edges[j][1] = k.e[i].rndd_minus;
            edges[j++][2] = k.e[i].len;
        }
        return edges;
    }

    public float Euc(float[] a, float[] b) {
        float sum = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            sum = (float)((double)sum + Math.pow(a[i] - b[i], 2.0));
        }
        return (float)Math.sqrt(sum);
    }

    private void MonteCarlo(double[][] edges, Point[] coors) {
        int k;
        double pVal = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        double aveZ = 0.0;
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        this.randEdges = new double[this.MCitors][Math.min(1000, coors.length - 1)];
        for (int i = 0; i < coors.length; ++i) {
            if ((double)coors[i].getPoint()[0] > maxX) {
                maxX = coors[i].getPoint()[0];
            }
            if ((double)coors[i].getPoint()[1] > maxY) {
                maxY = coors[i].getPoint()[1];
            }
            if ((double)coors[i].getPoint()[2] > maxZ) {
                maxZ = coors[i].getPoint()[2];
            }
            if ((double)coors[i].getPoint()[0] < minX) {
                minX = coors[i].getPoint()[0];
            }
            if ((double)coors[i].getPoint()[1] < minY) {
                minY = coors[i].getPoint()[1];
            }
            if ((double)coors[i].getPoint()[2] < minZ) {
                minZ = coors[i].getPoint()[2];
            }
            aveZ += (double)coors[i].getPoint()[2];
        }
        aveZ /= (double)coors.length;
        this.jpb.setStringPainted(true);
        Thread[] t = new Thread[1];
        for (k = 0; k < t.length; ++k) {
            t[k] = new Thread(new runMonteCarlo(k * this.MCitors / t.length, (k + 1) * this.MCitors / t.length, coors, maxX, maxY, maxZ, minX, minY, minZ, aveZ));
            t[k].start();
        }
        try {
            for (k = 0; k < t.length; ++k) {
                t[k].join();
            }
        }
        catch (Exception err) {
            // empty catch block
        }
    }

    public double[] sortEdges(double[][] edges) {
        double[] sortedEdges = new double[edges.length];
        for (int i = 0; i < edges.length; ++i) {
            sortedEdges[i] = edges[i][2];
        }
        Arrays.sort(sortedEdges);
        return sortedEdges;
    }

    private double getPvalue() {
        double longestDist = 0.0;
        double[] sortedEdges = this.sortEdges(this.edges);
        for (int j = 0; j < sortedEdges.length; ++j) {
            int count = 0;
            for (int a = 0; a < this.randEdges.length; ++a) {
                for (int b = 0; b < this.randEdges[a].length; ++b) {
                    if (!(this.randEdges[a][b] <= sortedEdges[j])) continue;
                    ++count;
                }
            }
            double frac = (double)count / (double)(this.randEdges.length * this.randEdges[0].length);
            if (frac > this.alpha) {
                return longestDist / sortedEdges[sortedEdges.length - 1];
            }
            longestDist = sortedEdges[j];
        }
        return longestDist / sortedEdges[sortedEdges.length - 1];
    }

    public clusterRun getClusterRun() {
        return this.cr;
    }

    public class runMonteCarlo
    implements Runnable {
        int iMin;
        int iMax;
        Point[] coors;
        Random r = new Random();
        double maxX;
        double minX;
        double maxY;
        double minY;
        double maxZ;
        double minZ;
        double aveZ;

        public runMonteCarlo(int iMin, int iMax, Point[] coors, double maxX, double maxY, double maxZ, double minX, double minY, double minZ, double aveZ) {
            this.iMin = iMin;
            this.iMax = iMax;
            this.coors = coors;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.aveZ = aveZ;
        }

        public void run() {
            double Area = (this.maxX - this.minX) * (this.maxY - this.minY);
            double density = (double)this.coors.length / Area;
            double diff = (this.maxX - this.minX) / (this.maxY - this.minY);
            double newArea = 1000.0 / density;
            double newX = Math.sqrt(newArea / (1.0 / diff));
            double newY = newArea / newX;
            if (this.coors.length >= 1000) {
                // empty if block
            }
            for (int i = this.iMin; i < this.iMax; ++i) {
                MSTCluster.this.jpb.setValue((int)(100.0 * (double)MSTCluster.this.jpbItor++ / (double)MSTCluster.this.MCitors));
                Point[] rand = new Point[Math.min(1000, this.coors.length)];
                for (int j = 0; j < rand.length; ++j) {
                    double[] coors = new double[3];
                    if (MSTCluster.this.gaussian) {
                        coors[0] = this.r.nextGaussian() * (coors.length < 1000 ? this.maxX - this.minX : newX);
                        coors[1] = this.r.nextGaussian() * (coors.length < 1000 ? this.maxY - this.minY : newY);
                        coors[2] = 0.0;
                    } else {
                        coors[0] = this.r.nextDouble() * (this.maxX - this.minX);
                        coors[1] = this.r.nextDouble() * (this.maxY - this.minY);
                        coors[2] = 0.0;
                    }
                    rand[j] = new Point(coors);
                }
                double[][] Edges2 = MSTCluster.this.MCST(rand);
                double[] sortedEdges = MSTCluster.this.sortEdges(Edges2);
                for (int k = 0; k < Edges2.length; ++k) {
                    ((MSTCluster)MSTCluster.this).randEdges[i][k] = sortedEdges[k];
                }
            }
        }
    }
}

