/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.Point;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.cluststruct.cluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.autosome.launch.Settings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class clusterRun
implements Serializable {
    public Point[] nodes;
    public double[][] edges;
    public List<Integer>[] ids;
    public String[] labelsSorted;
    public double[][] membership;
    public double[] memTotal;
    public float[][] DEC;
    public double thresh;
    public cluster[] c;
    public boolean[] usedEdges;
    private int size = 0;
    private String inputFile = new String();
    public String[][] fcn_nodes;
    public String[][] fcn_edges;
    public int[] columnClusters;
    public double Fmeasure = 0.0;
    public double Precision = 0.0;
    public double Recall = 0.0;
    public double NMI = 0.0;
    public double adjRand = 0.0;

    public clusterRun(Point[] nodes, double[][] edges, List<Integer>[] ids, float[][] DEC2, double thresh, int size) {
        this.nodes = nodes;
        this.edges = edges;
        this.ids = ids;
        this.thresh = thresh;
        this.DEC = DEC2;
        this.usedEdges = new boolean[edges.length];
        for (int i = 0; i < this.usedEdges.length; ++i) {
            this.usedEdges[i] = false;
        }
        this.size = size;
    }

    public clusterRun(cluster[] c) {
        this.c = c;
        this.usedEdges = new boolean[this.edges.length];
    }

    public clusterRun(Point[] nodes, List<Integer>[] ids, int size) {
        this.nodes = nodes;
        this.ids = ids;
        this.size = size;
    }

    public clusterRun() {
    }

    public void setInputFile(String input) {
        this.inputFile = input;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void makeMembership(Settings s) {
        int i;
        int dataCount = 0;
        for (i = 0; i < this.c.length; ++i) {
            dataCount += this.c[i].ids.size();
        }
        this.membership = new double[dataCount][this.c.length];
        this.labelsSorted = new String[dataCount];
        for (i = 0; i < this.c.length; ++i) {
            for (int j = 0; j < this.c[i].ids.size(); ++j) {
                int id = this.c[i].ids.get(j);
                this.labelsSorted[id] = s.input[id].toString();
                this.membership[id][i] = 1.0;
            }
        }
    }

    public void updateFuzzy(double d) {
        for (int i = 0; i < this.membership.length; ++i) {
            int j = 0;
            while (j < this.membership[i].length) {
                double[] dArray = this.membership[i];
                int n = j++;
                dArray[n] = dArray[n] * d;
            }
        }
    }

    public void sumMembership() {
        this.memTotal = new double[this.membership[0].length];
        for (int i = 0; i < this.memTotal.length; ++i) {
            for (int j = 0; j < this.membership.length; ++j) {
                if (!(this.membership[j][i] > 0.0)) continue;
                int n = i;
                this.memTotal[n] = this.memTotal[n] + (double)((int)this.membership[j][i]);
            }
        }
    }

    public void cleanFuzzy() {
        for (int i = 0; i < this.membership.length; ++i) {
            double max = 0.0;
            int pos = 0;
            for (int j = 0; j < this.membership[i].length; ++j) {
                if (!(this.membership[i][j] >= max)) continue;
                max = this.membership[i][j];
                pos = j;
            }
            for (int k = 0; k < this.membership[i].length; ++k) {
                this.membership[i][k] = 0.0;
            }
            this.membership[i][pos] = max;
        }
    }

    public void printFuzzy() {
        for (int i = 0; i < this.membership.length; ++i) {
            String[] tokens = this.labelsSorted[i].split(",");
            System.out.print(tokens[0] + "\t");
            for (int j = 0; j < this.membership[i].length; ++j) {
                System.out.print(this.membership[i][j] + "\t");
            }
            System.out.println();
        }
    }

    public void setMetrics(double F, double P, double R, double NMI, double adjRand) {
        this.Fmeasure = F;
        this.Precision = P;
        this.Recall = R;
        this.NMI = NMI;
        this.adjRand = adjRand;
    }

    public void edgeSort() {
        int i;
        Object[] se = new sortEdges[this.edges.length];
        for (i = 0; i < se.length; ++i) {
            se[i] = new sortEdges(this.edges[i]);
        }
        Arrays.sort(se);
        for (i = 0; i < se.length; ++i) {
            this.edges[i] = ((sortEdges)se[i]).edge;
        }
    }

    public int getSize() {
        return this.size;
    }

    private class sortEdges
    implements Comparable {
        double dist;
        double[] edge;

        public sortEdges(double[] edge) {
            this.edge = edge;
            this.dist = edge[2];
        }

        public int compareTo(Object o) {
            double dist2 = ((sortEdges)o).dist;
            return this.dist < dist2 ? -1 : (this.dist == dist2 ? 0 : 1);
        }
    }
}

