/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AttributeList;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.ClusterMethod;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.HierarchicalCluster;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalContext {
    CyNetwork network;
    @Tunable(description="Linkage", gravity=1.0)
    public ListSingleSelection<ClusterMethod> linkage = new ListSingleSelection((Object[])HierarchicalCluster.linkageTypes);
    @Tunable(description="Distance Metric", gravity=2.0)
    public ListSingleSelection<DistanceMetric> metric = new ListSingleSelection((Object[])BaseMatrix.distanceTypes);
    @ContainsTunables
    public AttributeList attributeList = null;
    @Tunable(description="Only use selected nodes/edges for cluster", groups={"Clustering Parameters"}, gravity=60.0)
    public boolean selectedOnly = false;
    @Tunable(description="Cluster attributes as well as nodes", groups={"Clustering Parameters"}, gravity=61.0)
    public boolean clusterAttributes = true;
    @Tunable(description="Ignore nodes/edges with no data", groups={"Clustering Parameters"}, gravity=62.0)
    public boolean ignoreMissing = true;
    @Tunable(description="Set missing data to zero (not common)", groups={"Advanced Parameters"}, params="displayState=collapsed", gravity=63.0)
    public boolean zeroMissing = false;
    @Tunable(description="Adjust loops (not common)", groups={"Advanced Parameters"}, gravity=64.0)
    public boolean adjustDiagonals = false;
    @Tunable(description="Create groups from clusters", groups={"Visualization Options"}, gravity=65.0)
    public boolean createGroups = false;
    @Tunable(description="Show TreeView when complete", groups={"Visualization Options"}, gravity=66.0)
    public boolean showUI = false;

    public HierarchicalContext() {
        this.linkage.setSelectedValue((Object)ClusterMethod.AVERAGE_LINKAGE);
    }

    public List<String> getParams(Matrix matrix) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("linkage=" + ((ClusterMethod)((Object)this.linkage.getSelectedValue())).toString());
        params.add("metric=" + ((DistanceMetric)((Object)this.metric.getSelectedValue())).toString());
        if (this.attributeList.getNodeAttributeList() != null) {
            params.add("nodeAttributeList=" + this.attributeList.getNodeAttributeList().toString());
        }
        if (this.attributeList.getEdgeAttribute() != null) {
            params.add("edgeAttribute=" + this.attributeList.getEdgeAttribute());
        }
        params.add("selectedOnly=" + this.selectedOnly);
        params.add("clusterAttributes=" + this.clusterAttributes);
        params.add("ignoreMissing=" + this.ignoreMissing);
        params.add("zeroMissing=" + this.zeroMissing);
        params.add("createGroups=" + this.createGroups);
        params.add("adjustDiagonals=" + this.adjustDiagonals);
        if (this.adjustDiagonals) {
            params.add("diagonals=" + matrix.getValue(0, 0));
        }
        return params;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.attributeList == null) {
            this.attributeList = new AttributeList(network);
        } else {
            this.attributeList.setNetwork(network);
        }
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public DistanceMetric getDistanceMetric() {
        return (DistanceMetric)((Object)this.metric.getSelectedValue());
    }

    public ClusterMethod getLinkage() {
        return (ClusterMethod)((Object)this.linkage.getSelectedValue());
    }
}

