/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.ClusterMethod;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.HierarchicalCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.HierarchicalContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.NodeComparator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hierarchical.TreeNode;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunHierarchical {
    static final int IS = 0;
    static final int JS = 1;
    String[] weightAttributes;
    TaskMonitor monitor;
    HierarchicalContext context;
    DistanceMetric metric;
    CyNetwork network;
    Integer[] rowOrder;
    List<String> attrList;
    final boolean debug = false;
    Matrix matrix = null;
    ClusterMethod clusterMethod;

    public RunHierarchical(CyNetwork network, String[] weightAttributes, DistanceMetric metric, ClusterMethod clusterMethod, TaskMonitor monitor, HierarchicalContext context) {
        this.weightAttributes = weightAttributes;
        this.metric = metric;
        this.clusterMethod = clusterMethod;
        this.monitor = monitor;
        this.context = context;
        this.network = network;
    }

    public Integer[] cluster(boolean transpose) {
        TreeNode[] nodeList;
        String keyword = "GENE";
        if (transpose) {
            keyword = "ARRY";
        }
        if (this.monitor != null) {
            this.monitor.setStatusMessage("Creating distance matrix");
        }
        this.matrix = new Matrix(this.network, this.weightAttributes, transpose, this.context.ignoreMissing, this.context.selectedOnly);
        this.matrix.setUniformWeights();
        if (this.context.zeroMissing) {
            this.matrix.setMissingToZero();
        }
        if (this.context.adjustDiagonals && this.matrix.isSymmetrical()) {
            this.matrix.adjustDiagonals();
        }
        if (this.monitor != null) {
            this.monitor.setStatusMessage("Clustering...");
        }
        if ((nodeList = this.treeCluster(this.matrix, this.metric, this.clusterMethod)) == null || nodeList.length == 0) {
            this.monitor.showMessage(TaskMonitor.Level.ERROR, "treeCluster returned empty tree!");
        }
        if (this.metric == DistanceMetric.EUCLIDEAN || this.metric == DistanceMetric.CITYBLOCK) {
            int node;
            double scale = 0.0;
            for (node = 0; node < nodeList.length; ++node) {
                if (!(nodeList[node].getDistance() > scale)) continue;
                scale = nodeList[node].getDistance();
            }
            if (scale != 0.0) {
                for (node = 0; node < nodeList.length; ++node) {
                    double dist = nodeList[node].getDistance();
                    nodeList[node].setDistance(dist / scale);
                }
            }
        }
        if (this.monitor != null) {
            this.monitor.setStatusMessage("Creating tree");
        }
        double[] nodeOrder = new double[nodeList.length];
        int[] nodeCounts = new int[nodeList.length];
        String[] nodeID = new String[nodeList.length];
        this.attrList = new ArrayList<String>(nodeList.length);
        for (int node = 0; node < nodeList.length; ++node) {
            String ID2;
            double counts2;
            double order2;
            String ID1;
            double counts1;
            double order1;
            int min1 = nodeList[node].getLeft();
            int min2 = nodeList[node].getRight();
            nodeID[node] = "GROUP" + (node + 1) + "X";
            nodeList[node].setName("GROUP" + (node + 1) + "X");
            if (min1 < 0) {
                int index1 = -min1 - 1;
                order1 = nodeOrder[index1];
                counts1 = nodeCounts[index1];
                ID1 = nodeList[index1].getName();
                nodeList[node].setDistance(Math.max(nodeList[node].getDistance(), nodeList[index1].getDistance()));
            } else {
                order1 = min1;
                counts1 = 1.0;
                ID1 = this.matrix.getRowLabel(min1);
            }
            if (min2 < 0) {
                int index2 = -min2 - 1;
                order2 = nodeOrder[index2];
                counts2 = nodeCounts[index2];
                ID2 = nodeList[index2].getName();
                nodeList[node].setDistance(Math.max(nodeList[node].getDistance(), nodeList[index2].getDistance()));
            } else {
                order2 = min2;
                counts2 = 1.0;
                ID2 = this.matrix.getRowLabel(min2);
            }
            this.attrList.add(node, nodeList[node].getName() + "\t" + ID1 + "\t" + ID2 + "\t" + (1.0 - nodeList[node].getDistance()));
            nodeCounts[node] = (int)counts1 + (int)counts2;
            nodeOrder[node] = (counts1 * order1 + counts2 * order2) / (counts1 + counts2);
        }
        this.rowOrder = this.treeSort(this.matrix, nodeList.length, nodeOrder, nodeCounts, nodeList);
        if (!this.matrix.isTransposed()) {
            if (this.monitor != null) {
                this.monitor.setStatusMessage("Creating groups");
            }
            ArrayList groupNames = new ArrayList(nodeList.length);
            if (this.context.createGroups) {
                // empty if block
            }
            ModelUtils.createAndSetLocal(this.network, (CyIdentifiable)this.network, HierarchicalCluster.GROUP_ATTRIBUTE, groupNames, List.class, String.class);
        }
        return this.rowOrder;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public List<String> getAttributeList() {
        return this.attrList;
    }

    private TreeNode[] treeCluster(Matrix matrix, DistanceMetric metric, ClusterMethod clusterMethod) {
        double[][] distanceMatrix = matrix.getDistanceMatrix(metric);
        TreeNode[] result = null;
        switch (clusterMethod) {
            case SINGLE_LINKAGE: {
                result = this.pslCluster(matrix, distanceMatrix, metric);
                break;
            }
            case MAXIMUM_LINKAGE: {
                result = this.pmlcluster(matrix.nRows(), distanceMatrix);
                break;
            }
            case AVERAGE_LINKAGE: {
                result = this.palcluster(matrix.nRows(), distanceMatrix);
                break;
            }
            case CENTROID_LINKAGE: {
                result = this.pclcluster(matrix, distanceMatrix, metric);
            }
        }
        return result;
    }

    private TreeNode[] pslCluster(Matrix matrix, double[][] distanceMatrix, DistanceMetric metric) {
        int i;
        int row;
        int nRows = matrix.nRows();
        int nNodes = nRows - 1;
        int[] vector = new int[nNodes];
        TreeNode[] nodeList = new TreeNode[nNodes];
        for (int i2 = 0; i2 < nNodes; ++i2) {
            vector[i2] = i2;
            nodeList[i2] = new TreeNode(Double.MAX_VALUE);
        }
        int k = 0;
        double[] temp = new double[nNodes];
        for (row = 0; row < nRows; ++row) {
            int j;
            if (distanceMatrix != null) {
                for (j = 0; j < row; ++j) {
                    temp[j] = distanceMatrix[row][j];
                }
            } else {
                for (j = 0; j < row; ++j) {
                    temp[j] = metric.getMetric(matrix, matrix, matrix.getWeights(), row, j);
                }
            }
            for (j = 0; j < row; ++j) {
                k = vector[j];
                if (nodeList[j].getDistance() >= temp[j]) {
                    if (nodeList[j].getDistance() < temp[k]) {
                        temp[k] = nodeList[j].getDistance();
                    }
                    nodeList[j].setDistance(temp[j]);
                    vector[j] = row;
                    continue;
                }
                if (!(temp[j] < temp[k])) continue;
                temp[k] = temp[j];
            }
            for (j = 0; j < row; ++j) {
                if (vector[j] != nNodes && !(nodeList[j].getDistance() >= nodeList[vector[j]].getDistance())) continue;
                vector[j] = row;
            }
        }
        for (row = 0; row < nNodes; ++row) {
            nodeList[row].setLeft(row);
        }
        Arrays.sort(nodeList, new NodeComparator());
        int[] index = new int[nRows];
        for (i = 0; i < nRows; ++i) {
            index[i] = i;
        }
        for (i = 0; i < nNodes; ++i) {
            int j = nodeList[i].getLeft();
            k = vector[j];
            nodeList[i].setLeft(index[j]);
            nodeList[i].setRight(index[k]);
            index[k] = -i - 1;
        }
        return nodeList;
    }

    private TreeNode[] pclcluster(Matrix matrix, double[][] distanceMatrix, DistanceMetric metric) {
        int nRows = matrix.nRows();
        int nColumns = matrix.nColumns();
        int nNodes = nRows - 1;
        double[][] mask = new double[matrix.nRows()][matrix.nColumns()];
        TreeNode[] nodeList = new TreeNode[nNodes];
        Matrix newData = new Matrix(matrix);
        int[] distID = new int[nRows];
        for (int row = 0; row < nRows; ++row) {
            distID[row] = row;
            for (int col = 0; col < nColumns; ++col) {
                mask[row][col] = newData.hasValue(row, col) ? 1.0 : 0.0;
            }
            if (row >= nNodes) continue;
            nodeList[row] = new TreeNode(Double.MAX_VALUE);
        }
        int[] pair = new int[2];
        for (int inode = 0; inode < nNodes; ++inode) {
            int i;
            int col;
            pair[0] = 1;
            pair[1] = 0;
            double distance = this.findClosestPair(nRows - inode, distanceMatrix, pair);
            nodeList[inode].setDistance(distance);
            int is = pair[0];
            int js = pair[1];
            nodeList[inode].setLeft(distID[js]);
            nodeList[inode].setRight(distID[is]);
            for (col = 0; col < nColumns; ++col) {
                double jsValue = newData.doubleValue(js, col);
                double isValue = newData.doubleValue(is, col);
                double newValue = 0.0;
                if (newData.hasValue(js, col)) {
                    newValue = jsValue * mask[js][col];
                }
                if (newData.hasValue(is, col)) {
                    newValue += isValue * mask[is][col];
                }
                if (newData.hasValue(js, col) || newData.hasValue(is, col)) {
                    newData.setValue(js, col, newValue);
                }
                double[] dArray = mask[js];
                int n = col;
                dArray[n] = dArray[n] + mask[is][col];
                if (mask[js][col] == 0.0) continue;
                newData.setValue(js, col, newValue / mask[js][col]);
            }
            for (col = 0; col < nColumns; ++col) {
                mask[is][col] = mask[nNodes - inode][col];
                newData.setValue(is, col, newData.getValue(nNodes - inode, col));
            }
            distID[is] = distID[nNodes - inode];
            for (i = 0; i < is; ++i) {
                distanceMatrix[is][i] = distanceMatrix[nNodes - inode][i];
            }
            for (i = is + 1; i < nNodes - inode; ++i) {
                distanceMatrix[i][is] = distanceMatrix[nNodes - inode][i];
            }
            distID[js] = -inode - 1;
            for (i = 0; i < js; ++i) {
                distanceMatrix[js][i] = metric.getMetric(newData, newData, newData.getWeights(), js, i);
            }
            for (i = js + 1; i < nNodes - inode; ++i) {
                distanceMatrix[i][js] = metric.getMetric(newData, newData, newData.getWeights(), js, i);
            }
        }
        return nodeList;
    }

    private TreeNode[] pmlcluster(int nRows, double[][] distanceMatrix) {
        int[] clusterID = new int[nRows];
        TreeNode[] nodeList = new TreeNode[nRows - 1];
        for (int j = 0; j < nRows; ++j) {
            clusterID[j] = j;
        }
        int[] pair = new int[2];
        for (int n = nRows; n > 1; --n) {
            int j;
            pair[0] = 1;
            pair[1] = 2;
            if (nodeList[nRows - n] == null) {
                nodeList[nRows - n] = new TreeNode(Double.MAX_VALUE);
            }
            nodeList[nRows - n].setDistance(this.findClosestPair(n, distanceMatrix, pair));
            int is = pair[0];
            int js = pair[1];
            for (j = 0; j < js; ++j) {
                distanceMatrix[js][j] = Math.max(distanceMatrix[is][j], distanceMatrix[js][j]);
            }
            for (j = js + 1; j < is; ++j) {
                distanceMatrix[j][js] = Math.max(distanceMatrix[is][j], distanceMatrix[j][js]);
            }
            for (j = is + 1; j < n; ++j) {
                distanceMatrix[j][js] = Math.max(distanceMatrix[j][is], distanceMatrix[j][js]);
            }
            for (j = 0; j < is; ++j) {
                distanceMatrix[is][j] = distanceMatrix[n - 1][j];
            }
            for (j = is + 1; j < n - 1; ++j) {
                distanceMatrix[j][is] = distanceMatrix[n - 1][j];
            }
            nodeList[nRows - n].setLeft(clusterID[is]);
            nodeList[nRows - n].setRight(clusterID[js]);
            clusterID[js] = n - nRows - 1;
            clusterID[is] = clusterID[n - 1];
        }
        return nodeList;
    }

    private TreeNode[] palcluster(int nRows, double[][] distanceMatrix) {
        int[] clusterID = new int[nRows];
        int[] number = new int[nRows];
        TreeNode[] nodeList = new TreeNode[nRows - 1];
        for (int j = 0; j < nRows; ++j) {
            number[j] = 1;
            clusterID[j] = j;
        }
        int[] pair = new int[2];
        for (int n = nRows; n > 1; --n) {
            int j;
            int sum = 0;
            pair[0] = 1;
            pair[1] = 0;
            if (nodeList[nRows - n] == null) {
                nodeList[nRows - n] = new TreeNode(Double.MAX_VALUE);
            }
            double distance = this.findClosestPair(n, distanceMatrix, pair);
            nodeList[nRows - n].setDistance(distance);
            int is = pair[0];
            int js = pair[1];
            nodeList[nRows - n].setLeft(clusterID[is]);
            nodeList[nRows - n].setRight(clusterID[js]);
            sum = number[is] + number[js];
            for (j = 0; j < js; ++j) {
                distanceMatrix[js][j] = (distanceMatrix[is][j] * (double)number[is] + distanceMatrix[js][j] * (double)number[js]) / (double)sum;
            }
            for (j = js + 1; j < is; ++j) {
                distanceMatrix[j][js] = (distanceMatrix[is][j] * (double)number[is] + distanceMatrix[j][js] * (double)number[js]) / (double)sum;
            }
            for (j = is + 1; j < n; ++j) {
                distanceMatrix[j][js] = (distanceMatrix[j][is] * (double)number[is] + distanceMatrix[j][js] * (double)number[js]) / (double)sum;
            }
            for (j = 0; j < is; ++j) {
                distanceMatrix[is][j] = distanceMatrix[n - 1][j];
            }
            for (j = is + 1; j < n - 1; ++j) {
                distanceMatrix[j][is] = distanceMatrix[n - 1][j];
            }
            number[js] = sum;
            number[is] = number[n - 1];
            clusterID[js] = n - nRows - 1;
            clusterID[is] = clusterID[n - 1];
        }
        return nodeList;
    }

    private double findClosestPair(int n, double[][] distanceMatrix, int[] pair) {
        int ip = 1;
        int jp = 0;
        double distance = distanceMatrix[1][0];
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double temp = distanceMatrix[i][j];
                if (!(temp < distance)) continue;
                distance = temp;
                ip = i;
                jp = j;
            }
        }
        pair[0] = ip;
        pair[1] = jp;
        return distance;
    }

    private Integer[] treeSort(Matrix matrix, int nNodes, double[] nodeOrder, int[] nodeCounts, TreeNode[] nodeList) {
        int i;
        int nElements = nNodes + 1;
        double[] newOrder = new double[nElements];
        int[] clusterIDs = new int[nElements];
        for (i = 0; i < nElements; ++i) {
            clusterIDs[i] = i;
        }
        for (i = 0; i < nNodes; ++i) {
            int clusterID;
            int j;
            double increase;
            int count2;
            double order2;
            int count1;
            double order1;
            int i1 = nodeList[i].getLeft();
            int i2 = nodeList[i].getRight();
            if (i1 < 0) {
                order1 = nodeOrder[-i1 - 1];
                count1 = nodeCounts[-i1 - 1];
            } else {
                order1 = i1;
                count1 = 1;
            }
            if (i2 < 0) {
                order2 = nodeOrder[-i2 - 1];
                count2 = nodeCounts[-i2 - 1];
            } else {
                order2 = i2;
                count2 = 1;
            }
            if (i1 < i2) {
                increase = count2;
                if (order1 < order2) {
                    increase = count1;
                }
                for (j = 0; j < nElements; ++j) {
                    clusterID = clusterIDs[j];
                    if (clusterID == i1 && order1 >= order2) {
                        int n = j;
                        newOrder[n] = newOrder[n] + increase;
                    }
                    if (clusterID == i2 && order1 < order2) {
                        int n = j;
                        newOrder[n] = newOrder[n] + increase;
                    }
                    if (clusterID != i1 && clusterID != i2) continue;
                    clusterIDs[j] = -i - 1;
                }
                continue;
            }
            increase = count2;
            if (order1 <= order2) {
                increase = count1;
            }
            for (j = 0; j < nElements; ++j) {
                clusterID = clusterIDs[j];
                if (clusterID == i1 && order1 > order2) {
                    int n = j;
                    newOrder[n] = newOrder[n] + increase;
                }
                if (clusterID == i2 && order1 <= order2) {
                    int n = j;
                    newOrder[n] = newOrder[n] + increase;
                }
                if (clusterID != i1 && clusterID != i2) continue;
                clusterIDs[j] = -i - 1;
            }
        }
        Integer[] rowOrder = matrix.indexSort(newOrder, newOrder.length);
        return rowOrder;
    }
}

