/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Clusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.HopachPAM;
import org.junit.Assert;
import org.junit.Test;

public class HopachPAMTest {
    @Test
    public void testRun() {
        Double[] data = new Double[]{100.9, 100.9, 100.85, 100.85, 100.8, 100.8, 0.15, 0.15, 0.2, 0.2, 0.12, 0.12, 0.05, 0.05, 0.04, 0.04, 0.0, 0.0, 0.02, 0.02};
        int[] ans = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2, 2};
        BaseMatrix mat = new BaseMatrix(0, 2, data);
        HopachPAM h = new HopachPAM(mat, DistanceMetric.CITYBLOCK);
        Clusters c = h.run();
        for (int i = 0; i < c.size(); ++i) {
            Assert.assertEquals((long)c.getClusterIndex(i), (long)ans[i]);
        }
    }

    @Test
    public void testRunDown() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testInitLevel() {
        Double[] data = new Double[]{100.9, 100.9, 100.85, 100.85, 100.8, 100.8, 0.15, 0.15, 0.2, 0.2, 0.12, 0.12, 0.05, 0.05, 0.04, 0.04, 0.0, 0.0, 0.02, 0.02};
        int[] ans = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2, 2};
        BaseMatrix mat = new BaseMatrix(0, 2, data);
        HopachPAM h = new HopachPAM(mat, DistanceMetric.CITYBLOCK);
        Clusters c = h.initLevel();
        for (int i = 0; i < c.size(); ++i) {
            Assert.assertEquals((long)c.getClusterIndex(i), (long)ans[i]);
        }
    }

    @Test
    public void testCollapse() {
        Double[] data = new Double[]{0.15, 0.15, 0.2, 0.2, 0.12, 0.12, 0.05, 0.05, 0.0, 0.0, 0.06, 0.06, 0.015, 0.015, 0.01, 0.01, 0.03, 0.03, 0.04, 0.04, 0.02, 0.02};
        int[] initMedoids = new int[]{0, 0, 0, 3, 3, 3, 3, 5, 5, 5, 5};
        int[] ans = new int[]{0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1};
        BaseMatrix mat = new BaseMatrix(0, 2, data);
        HopachPAM h = new HopachPAM(mat, DistanceMetric.CITYBLOCK);
        Clusters b = new Clusters(initMedoids);
        b.setCost(1.0);
        h.splits.set(0, b);
        Clusters c = h.collapse(0);
        for (int i = 0; i < c.size(); ++i) {
            Assert.assertEquals((long)c.getClusterIndex(i), (long)ans[i]);
        }
    }

    @Test
    public void testNearestClusters() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testNextLevel() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testSortSplit() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testSortInitLevel() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testSplitIsFinal() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testOptimizeOrderingCorrelation() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testOrderingCorrelation() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testDistanceMatrixToVector() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testIndexLTMatrixToVector() {
        Assert.fail((String)"Not yet implemented");
    }

    @Test
    public void testReorderDistanceVector() {
        Assert.fail((String)"Not yet implemented");
    }
}

