/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.kmeans;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AttributeList;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.KClusterAttributes;
import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMeansContext {
    CyNetwork network;
    @ContainsTunables
    public KClusterAttributes kcluster = new KClusterAttributes();
    @Tunable(description="Number of iterations", gravity=10.0)
    public int iterations = 50;
    @Tunable(description="Distance Metric", gravity=11.0)
    public ListSingleSelection<DistanceMetric> metric = new ListSingleSelection((Object[])BaseMatrix.distanceTypes);
    @ContainsTunables
    public AttributeList attributeList = null;
    public boolean selectedOnly = false;
    @Tunable(description="Cluster attributes as well as nodes", groups={"K-Means Parameters"}, gravity=101.0)
    public boolean clusterAttributes = false;
    @Tunable(description="Create groups from clusters", groups={"Visualization Options"}, gravity=150.0)
    public boolean createGroups = false;
    @Tunable(description="Show HeatMap when complete", groups={"Visualization Options"}, gravity=151.0)
    public boolean showUI = false;

    @Tunable(description="Use only selected nodes/edges for cluster", groups={"K-Means Parameters"}, gravity=100.0)
    public boolean getselectedOnly() {
        return this.selectedOnly;
    }

    public void setselectedOnly(boolean sel) {
        if (this.network != null && this.selectedOnly != sel) {
            this.kcluster.updateKEstimates(this.network, sel);
        }
        this.selectedOnly = sel;
    }

    public void setNetwork(CyNetwork network) {
        if (this.network != null && this.network.equals(network)) {
            return;
        }
        this.network = network;
        if (this.attributeList == null) {
            this.attributeList = new AttributeList(network);
        } else {
            this.attributeList.setNetwork(network);
        }
        this.kcluster.updateKEstimates(network, this.selectedOnly);
    }

    public CyNetwork getNetwork() {
        return this.network;
    }

    public DistanceMetric getDistanceMetric() {
        return (DistanceMetric)((Object)this.metric.getSelectedValue());
    }

    public List<String> getParams() {
        ArrayList<String> params = new ArrayList<String>();
        this.kcluster.addParams(params);
        params.add("iterations=" + this.iterations);
        params.add("metric=" + ((DistanceMetric)((Object)this.metric.getSelectedValue())).toString());
        params.add("nodeAttributeList=" + this.attributeList.getNodeAttributeList().toString());
        params.add("edgeAttribute=" + this.attributeList.getEdgeAttribute());
        params.add("selectedOnly=" + this.selectedOnly);
        params.add("clusterAttributes=" + this.clusterAttributes);
        params.add("createGroups=" + this.createGroups);
        return params;
    }
}

