/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.kmeans;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.AbstractKClusterAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.kmeans.KMeansContext;
import java.util.Random;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.work.TaskMonitor;

public class RunKCluster
extends AbstractKClusterAlgorithm {
    Random random = null;
    KMeansContext context;

    public RunKCluster(CyNetwork network, String[] weightAttributes, DistanceMetric metric, TaskMonitor monitor, KMeansContext context) {
        super(network, weightAttributes, metric, monitor);
        this.context = context;
    }

    public int kcluster(int nClusters, int nIterations, Matrix matrix, DistanceMetric metric, int[] clusterID) {
        int i;
        this.random = null;
        int nelements = matrix.nRows();
        int ifound = 1;
        int[] tclusterid = new int[nelements];
        int[] saved = new int[nelements];
        int[] mapping = new int[nClusters];
        int[] counts = new int[nClusters];
        double error = Double.MAX_VALUE;
        if (this.monitor != null) {
            this.monitor.setProgress(0.0);
        }
        Matrix cData = new Matrix(this.network, nClusters, matrix.nColumns());
        if (nIterations <= 1) {
            for (i = 0; i < clusterID.length; ++i) {
                tclusterid[i] = clusterID[i];
            }
            nIterations = 1;
        } else {
            for (i = 0; i < nelements; ++i) {
                clusterID[i] = 0;
            }
        }
        int iteration = 0;
        do {
            int i2;
            int i3;
            if (this.monitor != null) {
                this.monitor.setProgress((double)iteration / (double)nIterations);
            }
            double total = Double.MAX_VALUE;
            int counter = 0;
            int period = 10;
            if (nIterations != 0) {
                if (!this.context.kcluster.initializeNearCenter) {
                    this.randomAssign(nClusters, nelements, tclusterid);
                } else {
                    tclusterid = this.chooseCentralElementsAsCenters(nelements, nClusters, matrix.getDistanceMatrix(metric));
                }
            }
            for (i3 = 0; i3 < nClusters; ++i3) {
                counts[i3] = 0;
            }
            for (i3 = 0; i3 < nelements; ++i3) {
                int n = tclusterid[i3];
                counts[n] = counts[n] + 1;
            }
            do {
                double previous = total;
                total = 0.0;
                if (counter % period == 0) {
                    for (i2 = 0; i2 < nelements; ++i2) {
                        saved[i2] = tclusterid[i2];
                    }
                    if (period < 0x3FFFFFFF) {
                        period *= 2;
                    }
                }
                ++counter;
                this.getClusterMeans(nClusters, matrix, cData, tclusterid);
                for (i2 = 0; i2 < nelements; ++i2) {
                    int k = tclusterid[i2];
                    if (counts[k] == 1) continue;
                    double distance = metric.getMetric(matrix, cData, matrix.getWeights(), i2, k);
                    for (int j = 0; j < nClusters; ++j) {
                        double tdistance;
                        if (j == k || !((tdistance = metric.getMetric(matrix, cData, matrix.getWeights(), i2, j)) < distance)) continue;
                        distance = tdistance;
                        int n = tclusterid[i2];
                        counts[n] = counts[n] - 1;
                        tclusterid[i2] = j;
                        int n2 = j;
                        counts[n2] = counts[n2] + 1;
                    }
                    total += distance;
                }
                if (total >= previous) break;
                for (i2 = 0; i2 < nelements && saved[i2] == tclusterid[i2]; ++i2) {
                }
            } while (i2 != nelements);
            if (nIterations <= 1) {
                error = total;
                break;
            }
            for (i3 = 0; i3 < nClusters; ++i3) {
                mapping[i3] = -1;
            }
            int element = 0;
            for (element = 0; element < nelements; ++element) {
                int j = tclusterid[element];
                int k = clusterID[element];
                if (mapping[k] == -1) {
                    mapping[k] = j;
                    continue;
                }
                if (mapping[k] == j) continue;
                if (!(total < error)) break;
                ifound = 1;
                error = total;
                for (int i4 = 0; i4 < nelements; ++i4) {
                    clusterID[i4] = tclusterid[i4];
                }
                break;
            }
            if (element != nelements) continue;
            ++ifound;
        } while (++iteration < nIterations);
        return ifound;
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void randomAssign(int nClusters, int nElements, int[] clusterID) {
        int n = nElements - nClusters;
        int k = 0;
        int i = 0;
        for (i = 0; i < nClusters - 1; ++i) {
            double p = 1.0 / (double)(nClusters - 1);
            int j = this.binomial(n, p);
            n -= j;
            j += k + 1;
            while (k < j) {
                clusterID[k] = i;
                ++k;
            }
        }
        while (k < nElements) {
            clusterID[k] = i;
            ++k;
        }
        for (i = 0; i < nElements; ++i) {
            int j = (int)((double)i + (double)(nElements - i) * this.uniform());
            k = clusterID[j];
            clusterID[j] = clusterID[i];
            clusterID[i] = k;
        }
    }

    private void debugAssign(int nClusters, int nElements, int[] clusterID) {
        for (int element = 0; element < nElements; ++element) {
            clusterID[element] = element % nClusters;
        }
    }

    private int binomial(int n, double p) {
        int y;
        double q = 1.0 - p;
        if ((double)n * p < 30.0) {
            double s = p / q;
            double a = (double)(n + 1) * s;
            double r = Math.exp((double)n * Math.log(q));
            int x = 0;
            double u = this.uniform();
            while (true) {
                if (u < r) {
                    return x;
                }
                u -= r;
                r *= a / (double)(++x) - s;
            }
        }
        double fm = (double)n * p + p;
        int m = (int)fm;
        double p1 = Math.floor(2.195 * Math.sqrt((double)n * p * q) - 4.6 * q) + 0.5;
        double xm = (double)m + 0.5;
        double xl = xm - p1;
        double xr = xm + p1;
        double c = 0.134 + 20.5 / (15.3 + (double)m);
        double a = (fm - xl) / (fm - xl * p);
        double b = (xr - fm) / (xr * q);
        double lambdal = a * (1.0 + 0.5 * a);
        double lambdar = b * (1.0 + 0.5 * b);
        double p2 = p1 * (1.0 + 2.0 * c);
        double p3 = p2 + c / lambdal;
        double p4 = p3 + c / lambdar;
        while (true) {
            double u = this.uniform();
            double v = this.uniform();
            if ((u *= p4) <= p1) {
                return (int)(xm - p1 * v + u);
            }
            if (u > p2) {
                if (u > p3) {
                    y = (int)(xr - Math.log(v) / lambdar);
                    if (y > n) continue;
                    v = v * (u - p3) * lambdar;
                } else {
                    y = (int)(xl + Math.log(v) / lambdal);
                    if (y < 0) continue;
                    v = v * (u - p2) * lambdal;
                }
            } else {
                double x = xl + (u - p1) / c;
                if ((v = v * c + 1.0 - Math.abs((double)m - x + 0.5) / p1) > 1.0) continue;
                y = (int)x;
            }
            int k = Math.abs(y - m);
            if (k > 20 && (double)k < 0.5 * (double)n * p * q - 1.0) {
                double rho = (double)k / ((double)n * p * q) * (((double)k * ((double)k / 3.0 + 0.625) + 0.1666666666666) / ((double)n * p * q) + 0.5);
                double t = (double)(-k * k) / ((double)(2 * n) * p * q);
                double A = Math.log(v);
                if (A < t - rho) {
                    return y;
                }
                if (A > t + rho) continue;
                double x1 = y + 1;
                double f1 = m + 1;
                double z = n + 1 - m;
                double w = n - y + 1;
                double x2 = x1 * x1;
                double f2 = f1 * f1;
                double z2 = z * z;
                double w2 = w * w;
                if (A > xm * Math.log(f1 / x1) + ((double)(n - m) + 0.5) * Math.log(z / w) + (double)(y - m) * Math.log(w * p / (x1 * q)) + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / f2) / f2) / f2) / f2) / f1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / z2) / z2) / z2) / z2) / z / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / x2) / x2) / x2) / x2) / x1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / w2) / w2) / w2) / w2) / w / 166320.0) continue;
                return y;
            }
            double s = p / q;
            double aa = s * (double)(n + 1);
            double f = 1.0;
            int i = m;
            while (i < y) {
                f *= aa / (double)(++i) - s;
            }
            i = y;
            while (i < m) {
                f /= aa / (double)(++i) - s;
            }
            if (!(v > f)) break;
        }
        return y;
    }

    private double uniform() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random.nextDouble();
    }
}

