/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Clusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.Hopachable;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.hopach.types.SplitCost;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.pam.HopachablePAM;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.numeric.MedianSummarizer;
import org.junit.Assert;
import org.junit.Test;

public class HopachablePAMTest {
    @Test
    public void testSubset() {
        Double[] data = new Double[]{0.9, 0.9, 0.8, 0.8, 0.4, 0.4, 0.5, 0.5, 0.1, 0.1, 0.0, 0.0};
        int k = 3;
        int[] index = new int[]{0, 1, 5, 2, 4, 3};
        int[] ans = new int[]{0, 0, 1, 2, 1, 2};
        BaseMatrix mat = new BaseMatrix(0, 2, data);
        HopachablePAM pam = new HopachablePAM(null, mat, DistanceMetric.CITYBLOCK);
        Hopachable pamPermuted = pam.subset(index);
        Clusters c = pamPermuted.cluster(k);
        Assert.assertEquals((long)c.getNumberOfClusters(), (long)k);
        for (int i = 0; i < c.size(); ++i) {
            Assert.assertEquals((long)c.getClusterIndex(i), (long)ans[i]);
        }
        int[] subsetIndex = new int[]{2, 3, 4, 5};
        int[] subsetAns = new int[]{0, 0, 1, 1};
        int subsetK = 2;
        Hopachable pamSubset = pam.subset(subsetIndex);
        Clusters c2 = pamSubset.cluster(subsetK);
        Assert.assertEquals((long)c2.getNumberOfClusters(), (long)subsetK);
        for (int i = 0; i < c2.size(); ++i) {
            Assert.assertEquals((long)c2.getClusterIndex(i), (long)subsetAns[i]);
        }
    }

    @Test
    public void testSplit() {
        Double[] data = new Double[]{0.2, 0.2, 0.8, 0.8, 0.82, 0.82, 0.4, 0.5, 0.5, 0.4, 0.15, 0.15, 0.81, 0.81, 0.14, 0.14, 0.45, 0.45};
        int k = 3;
        int[] ans = new int[]{0, 1, 1, 2, 2, 0, 1, 0, 2};
        BaseMatrix mat = new BaseMatrix(0, 2, data);
        HopachablePAM pam = new HopachablePAM(null, mat, DistanceMetric.CITYBLOCK);
        pam.setParameters(9, 9, SplitCost.AVERAGE_SPLIT_SILHOUETTE, new MedianSummarizer());
        Clusters c = pam.split(false);
        Assert.assertEquals((long)c.getNumberOfClusters(), (long)k);
        for (int i = 0; i < c.size(); ++i) {
            Assert.assertEquals((long)c.getClusterIndex(i), (long)ans[i]);
        }
    }

    @Test
    public void testCollapse() {
        Double[] data = new Double[]{0.9, 0.9, 0.8, 0.8, 0.4, 0.4, 0.5, 0.5, 0.1, 0.1, 0.0, 0.0};
        int k = 3;
        BaseMatrix mat = new BaseMatrix(0, 2, data);
        HopachablePAM pam = new HopachablePAM(null, mat, DistanceMetric.CITYBLOCK);
        Clusters c1 = pam.cluster(k);
        Clusters c2 = pam.collapse(0, 1, c1);
        Clusters c3 = pam.collapse(1, 2, c1);
        Clusters c4 = pam.collapse(0, 2, c1);
        Assert.assertEquals((long)c2.getSizes().length, (long)(--k));
        Assert.assertEquals((long)c3.getSizes().length, (long)k);
        Assert.assertEquals((long)c4.getSizes().length, (long)k);
        Clusters c5 = pam.collapse(0, 1, c2);
        Assert.assertEquals((long)c5.getSizes().length, (long)(--k));
    }

    @Test
    public void testOrder() {
        Assert.fail((String)"Not yet implemented");
    }
}

