/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.BaseMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Clusters;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.DistanceMetric;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.Silhouettes;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class SilhouetteCalculator {
    public static Silhouettes calculate(BaseMatrix matrix, DistanceMetric metric, int[] labels) {
        double[][] distanceMatrix = matrix.getDistanceMatrix(metric);
        return SilhouetteCalculator.calculate(distanceMatrix, labels);
    }

    public static Silhouettes calculate(BaseMatrix matrix, DistanceMetric metric, Clusters clusters) {
        double[][] distanceMatrix = matrix.getDistanceMatrix(metric);
        return SilhouetteCalculator.calculate(distanceMatrix, clusters);
    }

    public static Silhouettes calculate(double[][] distancematrix, int[] labels) {
        return SilhouetteCalculator.calculate(distancematrix, new Clusters(labels));
    }

    public static Silhouettes calculate(double[][] distancematrix, Clusters clusters) {
        Silhouettes silresult = new Silhouettes();
        int samplenum = clusters.size();
        int[] clusterSizes = clusters.getSizes();
        for (int i = 0; i < samplenum; ++i) {
            double silhouettevalue = 0.0;
            double a = 0.0;
            double b = 0.0;
            Integer classlabel = clusters.getClusterIndex(i);
            int clusterSize = clusterSizes[classlabel];
            HashMap<Integer, Double> bvalues = new HashMap<Integer, Double>();
            for (int j = 0; j < samplenum; ++j) {
                if (i == j) continue;
                Integer currentclasslabel = clusters.getClusterIndex(j);
                double distancevalue = 0.0;
                if (bvalues.containsKey(currentclasslabel)) {
                    distancevalue = (Double)bvalues.get(currentclasslabel);
                }
                bvalues.put(currentclasslabel, distancevalue += distancematrix[i][j]);
            }
            double mindis = Double.MAX_VALUE;
            Integer minlabel = null;
            for (Integer kLabel : bvalues.keySet()) {
                int count = clusterSizes[kLabel];
                double value = (Double)bvalues.get(kLabel);
                if (kLabel.equals(classlabel)) {
                    a = value / (double)(count - 1);
                    continue;
                }
                if (!(value / (double)count < mindis)) continue;
                mindis = value / (double)count;
                minlabel = kLabel;
            }
            b = mindis;
            if (clusterSize == 1) {
                silresult.addSilhouette(0.0, minlabel);
            }
            silhouettevalue = a > b ? (b - a) / a : (b - a) / b;
            silresult.addSilhouette(silhouettevalue, minlabel);
        }
        return silresult;
    }

    public static Silhouettes silhouettes(double[][] S, Clusters clusters) {
        int m = S.length;
        int k = S[0].length;
        Silhouettes sils = new Silhouettes();
        int[] sizes = clusters.getSizes();
        for (int i = 0; i < m; ++i) {
            int c = clusters.getClusterIndex(i);
            if (sizes[c] == 1) {
                sils.addSilhouette(0.0, -1);
                continue;
            }
            double a = S[i][c];
            double b = Double.POSITIVE_INFINITY;
            int nearest = -1;
            for (int j = 0; j < k; ++j) {
                if (j == c || !(S[i][j] < b)) continue;
                b = S[i][j];
                nearest = j;
            }
            if (b < Double.POSITIVE_INFINITY) {
                double max = a < b ? b : a;
                sils.addSilhouette((b - a) / max, nearest);
                continue;
            }
            sils.addSilhouette(0.0, -1);
        }
        return sils;
    }

    public static void print(Silhouettes result, int[] labels) {
        TreeMap clusters = new TreeMap();
        for (int row = 0; row < labels.length; ++row) {
            if (!clusters.containsKey(labels[row])) {
                clusters.put(labels[row], new TreeSet());
            }
            ((SortedSet)clusters.get(labels[row])).add(result.getSilhouette(row));
        }
        for (Integer cluster2 : clusters.keySet()) {
            System.out.println("Cluster #" + cluster2);
            for (Double sil : (SortedSet)clusters.get(cluster2)) {
                System.out.println("Silhouette " + sil);
            }
        }
    }
}

