/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP;

import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;

public abstract class APMatrix {
    protected double lambda;
    protected DoubleMatrix2D matrix;
    protected DoubleMatrix2D s_matrix;

    public APMatrix(DoubleMatrix2D s_matrix, double lambda) {
        this.matrix = DoubleFactory2D.sparse.make(s_matrix.rows(), s_matrix.columns());
        this.s_matrix = s_matrix;
        this.lambda = lambda;
    }

    public abstract double getEvidence(int var1);

    public double get(int row, int column) {
        return this.matrix.get(row, column);
    }

    public void setDamped(int row, int column, double value) {
        double previousValue = this.matrix.get(row, column);
        this.matrix.set(row, column, previousValue * this.lambda + value * (1.0 - this.lambda));
    }

    public DoubleMatrix2D getMatrix() {
        return this.matrix;
    }

    protected void printVector(String v, DoubleMatrix1D vec) {
        System.out.print(v + ": ");
        for (int i = 0; i < this.s_matrix.rows(); ++i) {
            System.out.print(" " + vec.get(i));
        }
        System.out.println("");
    }
}

