/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP.APMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AP.ResponsibilityMatrix;

public class AvailabilityMatrix
extends APMatrix {
    private DoubleMatrix1D evidenceVector = null;

    public AvailabilityMatrix(DoubleMatrix2D s_matrix, double lambda) {
        super(s_matrix, lambda);
    }

    public double getEvidence(int row) {
        if (this.evidenceVector == null) {
            this.updateEvidence();
        }
        return this.evidenceVector.get(row);
    }

    public void updateEvidence() {
        this.evidenceVector = DoubleFactory1D.dense.make(this.s_matrix.rows());
        this.evidenceVector.assign(-1.7976931348623157E308);
        this.s_matrix.forEachNonZero((IntIntDoubleFunction)new CalculateEvidence(this.evidenceVector));
    }

    public void update(ResponsibilityMatrix r_matrix) {
        this.s_matrix.forEachNonZero((IntIntDoubleFunction)new UpdateAvailability(r_matrix));
    }

    class UpdateAvailability
    implements IntIntDoubleFunction {
        ResponsibilityMatrix rMatrix;

        public UpdateAvailability(ResponsibilityMatrix responsibilityMatrix) {
            this.rMatrix = responsibilityMatrix;
        }

        public double apply(int row, int col, double value) {
            double newValue = row != col ? Math.min(0.0, this.rMatrix.get(col, col) + this.rMatrix.getEvidence(col) - Math.max(0.0, this.rMatrix.get(row, col))) : this.rMatrix.getEvidence(col);
            AvailabilityMatrix.this.setDamped(row, col, newValue);
            return value;
        }
    }

    class CalculateEvidence
    implements IntIntDoubleFunction {
        DoubleMatrix1D maxVector;

        public CalculateEvidence(DoubleMatrix1D maxMat) {
            this.maxVector = maxMat;
        }

        public double apply(int row, int col, double value) {
            if (row != col) {
                this.maxVector.set(row, Math.max(this.maxVector.get(row), AvailabilityMatrix.this.get(row, col) + value));
            }
            return value;
        }
    }
}

