/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterAlgorithm;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.FuzzyNodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.NodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.group.CyGroup;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNetworkClusterer
extends AbstractClusterAlgorithm {
    CyTableManager tableManager = null;

    public static List<List<CyNode>> getNodeClusters(CyNetwork net) {
        String clusterAttribute = (String)net.getRow((CyIdentifiable)net, "LOCAL_ATTRS").get("__clusterAttribute", String.class);
        return AbstractNetworkClusterer.getNodeClusters(net, clusterAttribute);
    }

    public static List<List<CyNode>> getNodeClusters(CyNetwork net, String clusterAttribute) {
        ArrayList<List<CyNode>> clusterList = new ArrayList<List<CyNode>>();
        HashMap clusterMap = new HashMap();
        for (CyNode node : net.getNodeList()) {
            if (net.getRow((CyIdentifiable)node).get(clusterAttribute, Integer.class) == null) continue;
            Integer cluster2 = (Integer)net.getRow((CyIdentifiable)node).get(clusterAttribute, Integer.class);
            if (!clusterMap.containsKey(cluster2)) {
                ArrayList nodeList = new ArrayList();
                clusterMap.put(cluster2, nodeList);
                clusterList.add(nodeList);
            }
            ((List)clusterMap.get(cluster2)).add(node);
        }
        return clusterList;
    }

    public AbstractNetworkClusterer(ClusterManager clusterManager) {
        super(clusterManager);
        this.tableManager = clusterManager.getTableManager();
    }

    protected List<List<CyNode>> createGroups(CyNetwork network, List<NodeCluster> clusters, String group_attr) {
        ArrayList<List<CyNode>> clusterList = new ArrayList<List<CyNode>>();
        ArrayList<Long> groupList = new ArrayList<Long>();
        for (NodeCluster cluster2 : clusters) {
            CyGroup group;
            int clusterNumber = cluster2.getClusterNumber();
            String groupName = this.clusterAttributeName + "_" + clusterNumber;
            ArrayList<CyNode> nodeList = new ArrayList<CyNode>();
            for (CyNode node : cluster2) {
                nodeList.add(node);
                ModelUtils.createAndSetLocal(network, (CyIdentifiable)node, this.clusterAttributeName, clusterNumber, Integer.class, null);
            }
            if (this.createGroups && (group = this.clusterManager.createGroup(network, this.clusterAttributeName + "_" + clusterNumber, nodeList, null, true)) != null) {
                groupList.add(group.getGroupNode().getSUID());
                if (NodeCluster.hasScore()) {
                    ModelUtils.createAndSetLocal(network, (CyIdentifiable)group.getGroupNode(), this.clusterAttributeName + "_Score", cluster2.getClusterScore(), Double.class, null);
                }
            }
            clusterList.add(nodeList);
        }
        ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, group_attr, groupList, List.class, Long.class);
        ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__clusterType", this.getShortName(), String.class, null);
        ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__clusterAttribute", this.clusterAttributeName, String.class, null);
        if (this.params != null) {
            ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__clusterParams", this.params, List.class, String.class);
        }
        return clusterList;
    }

    protected List<List<CyNode>> createFuzzyGroups(CyNetwork network, List<FuzzyNodeCluster> clusters, String group_attr) {
        ArrayList<List<CyNode>> clusterList = new ArrayList<List<CyNode>>();
        ArrayList<Long> groupList = new ArrayList<Long>();
        for (FuzzyNodeCluster cluster2 : clusters) {
            CyGroup group;
            int clusterNumber = cluster2.getClusterNumber();
            String groupName = this.clusterAttributeName + "_" + clusterNumber;
            ArrayList<CyNode> nodeList = new ArrayList<CyNode>();
            for (CyNode node : cluster2) {
                nodeList.add(node);
                if (!FuzzyNodeCluster.hasScore()) continue;
                ModelUtils.createAndSetLocal(network, (CyIdentifiable)node, this.clusterAttributeName + "_" + clusterNumber + "_Membership", cluster2.getMembership(node), Double.class, null);
            }
            if (this.createGroups && (group = this.clusterManager.createGroup(network, this.clusterAttributeName + "_" + clusterNumber, nodeList, null, true)) != null) {
                groupList.add(group.getGroupNode().getSUID());
            }
            clusterList.add(nodeList);
        }
        List nodeList = network.getNodeList();
        for (int i = 0; i < nodeList.size(); ++i) {
            CyNode node = (CyNode)nodeList.get(i);
            ArrayList<Integer> listOfClusters = new ArrayList<Integer>();
            for (FuzzyNodeCluster cluster3 : clusters) {
                if (cluster3.getMembership(node) == null) continue;
                listOfClusters.add(cluster3.getClusterNumber());
            }
            ModelUtils.createAndSetLocal(network, (CyIdentifiable)node, this.clusterAttributeName, listOfClusters, List.class, Integer.class);
        }
        ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, group_attr, groupList, List.class, Long.class);
        ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__clusterType", this.getShortName(), String.class, null);
        ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__clusterAttribute", this.clusterAttributeName, String.class, null);
        if (this.params != null) {
            ModelUtils.createAndSetLocal(network, (CyIdentifiable)network, "__clusterParams", this.params, List.class, String.class);
        }
        return clusterList;
    }

    protected void removeGroups(CyNetwork network, String group_attr) {
        if (network.getDefaultNetworkTable().getColumn(group_attr) != null) {
            List groupList = network.getRow((CyIdentifiable)network, "LOCAL_ATTRS").getList(group_attr, Long.class);
            if (groupList != null) {
                for (Long groupSUID : groupList) {
                    this.clusterManager.removeGroup(network, groupSUID);
                }
            }
            network.getRow((CyIdentifiable)network, "LOCAL_ATTRS").set(group_attr, null);
        }
    }
}

