/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.FCM;

import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.AbstractClusterResults;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.DistanceMatrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.FuzzyNodeCluster;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.Matrix;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.SilhouetteCalculator;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.attributeClusterers.silhouette.Silhouettes;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.AbstractFuzzyNetworkClusterer;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.FCM.FCMContext;
import edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.FCM.RunFCM;
import edu.ucsf.rbvi.clusterMaker2.internal.api.ClusterManager;
import edu.ucsf.rbvi.clusterMaker2.internal.ui.NewNetworkView;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.swing.TunableUIHelper;

public class FCMCluster
extends AbstractFuzzyNetworkClusterer {
    RunFCM runFCM = null;
    public static String SHORTNAME = "fcml";
    public static String NAME = "Fuzzy C-Means Cluster";
    public static final String GROUP_ATTRIBUTE = "__FCMGroups.SUID";
    public static final String NONEATTRIBUTE = "--None--";
    protected Matrix distanceDataMatrix;
    private boolean selectedOnly = false;
    private boolean ignoreMissing = true;
    private CyTableFactory tableFactory = null;
    private CyTableManager tableManager = null;
    private DistanceMatrix distanceMatrix = null;
    private TaskMonitor monitor = null;
    private Silhouettes[] silhouetteResults = null;
    private String[] attributeArray = new String[1];
    @Tunable(description="Network to cluster", context="nogui")
    public CyNetwork network = null;
    @ContainsTunables
    public FCMContext context = null;

    public FCMCluster(FCMContext context, ClusterManager manager) {
        super(manager);
        this.context = context;
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
            this.tableFactory = this.clusterManager.getTableFactory();
            this.tableManager = this.clusterManager.getTableManager();
        }
        context.setNetwork(this.network);
    }

    public String getShortName() {
        return SHORTNAME;
    }

    @ProvidesTitle
    public String getName() {
        return NAME;
    }

    public void run(TaskMonitor taskmonitor) {
        this.monitor = taskmonitor;
        this.monitor.setTitle("Performing FCM cluster");
        if (this.network == null) {
            this.network = this.clusterManager.getNetwork();
        }
        Long networkID = this.network.getSUID();
        CyTable netAttributes = this.network.getDefaultNetworkTable();
        CyTable nodeAttributes = this.network.getDefaultNodeTable();
        CyTable edgeAttributes = this.network.getDefaultEdgeTable();
        this.distanceMatrix = this.context.edgeAttributeHandler.getMatrix();
        if (this.distanceMatrix == null) {
            this.monitor.showMessage(TaskMonitor.Level.ERROR, "Can't get distance matrix: no attribute value?");
            return;
        }
        this.createGroups = this.context.advancedAttributes.createGroups;
        this.clusterAttributeName = "CnC_Bicluster";
        this.distanceDataMatrix = new Matrix(this.network, 0, 0);
        this.distanceDataMatrix.buildDistanceMatrix(this.distanceMatrix);
        if (this.context.estimateClusterNumber && this.context.cNumber < 0) {
            int cEstimate;
            this.context.cNumber = cEstimate = this.cEstimate();
        }
        int[] mostRelevantCluster = new int[this.network.getNodeList().size()];
        FuzzyNodeCluster.fuzzyClusterCount = 0;
        this.runFCM = new RunFCM(this.distanceMatrix, this.context.iterations, this.context.cNumber, this.context.fIndex, this.context.beta, (Double)this.context.membershipThreshold.getValue(), this.context.maxThreads, this.monitor);
        this.runFCM.setDebug(this.debug);
        if (this.canceled) {
            return;
        }
        this.monitor.showMessage(TaskMonitor.Level.INFO, "Clustering...");
        List<FuzzyNodeCluster> clusters = this.runFCM.run(this.network, this.monitor, mostRelevantCluster);
        if (clusters == null) {
            return;
        }
        this.monitor.showMessage(TaskMonitor.Level.INFO, "Removing groups");
        this.removeGroups(this.network, GROUP_ATTRIBUTE);
        this.monitor.showMessage(TaskMonitor.Level.INFO, "Creating groups");
        this.params = new ArrayList();
        this.context.edgeAttributeHandler.setParams(this.params);
        List<List<CyNode>> nodeClusters = this.createFuzzyGroups(this.network, clusters, GROUP_ATTRIBUTE);
        this.results = new AbstractClusterResults(this.network, nodeClusters);
        this.monitor.showMessage(TaskMonitor.Level.INFO, "Done.  FCM results:\n" + this.results);
        if (this.context.vizProperties.showUI) {
            this.monitor.showMessage(TaskMonitor.Level.INFO, "Creating network");
            this.insertTasksAfterCurrentTask(new Task[]{new NewNetworkView(this.network, this.clusterManager, true, this.context.vizProperties.restoreEdges)});
        } else {
            this.monitor.showMessage(TaskMonitor.Level.INFO, "Done.  FCM results:\n" + this.results);
        }
        this.createFuzzyTable(clusters);
    }

    public void cancel() {
        this.canceled = true;
        this.runFCM.cancel();
    }

    public void setUIHelper(TunableUIHelper helper) {
        this.context.setUIHelper(helper);
    }

    private int cEstimate() {
        int nClusters = -1;
        TaskMonitor saveMonitor = this.monitor;
        this.silhouetteResults = new Silhouettes[this.context.cMax];
        int nThreads = Runtime.getRuntime().availableProcessors() - 1;
        if (nThreads > 1) {
            this.runThreadedSilhouette(this.context.cMax, this.context.iterations, nThreads, saveMonitor);
        } else {
            this.runLinearSilhouette(this.context.cMax, this.context.iterations, saveMonitor);
        }
        double maxSil = -1.7976931348623157E308;
        for (int cEstimate = 2; cEstimate < this.context.cMax; ++cEstimate) {
            double sil = this.silhouetteResults[cEstimate].getMean();
            if (!(sil > maxSil)) continue;
            maxSil = sil;
            nClusters = cEstimate;
        }
        return nClusters;
    }

    private void runThreadedSilhouette(int kMax, int nIterations, int nThreads, TaskMonitor saveMonitor) {
        int pool;
        ExecutorService[] threadPools = new ExecutorService[nThreads];
        for (pool = 0; pool < threadPools.length; ++pool) {
            threadPools[pool] = Executors.newFixedThreadPool(1);
        }
        for (int kEstimate = 2; kEstimate < kMax; ++kEstimate) {
            int[] clusters = new int[this.distanceDataMatrix.nRows()];
            RunCMeans r = new RunCMeans(this.distanceDataMatrix, clusters, kEstimate, nIterations, saveMonitor);
            threadPools[(kEstimate - 2) % nThreads].submit(r);
        }
        for (pool = 0; pool < threadPools.length; ++pool) {
            threadPools[pool].shutdown();
            try {
                boolean result = threadPools[pool].awaitTermination(7L, TimeUnit.DAYS);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void runLinearSilhouette(int cMax, int nIterations, TaskMonitor saveMonitor) {
        for (int cEstimate = 2; cEstimate < cMax; ++cEstimate) {
            int[] clusters = new int[this.distanceDataMatrix.nRows()];
            if (this.cancelled()) {
                return;
            }
            if (saveMonitor != null) {
                saveMonitor.setStatusMessage("Getting silhouette with a c estimate of " + cEstimate);
            }
            RunFCM silRunFCM = new RunFCM(this.distanceMatrix, this.context.iterations, cEstimate, this.context.fIndex, this.context.beta, (Double)this.context.membershipThreshold.getValue(), this.context.maxThreads, saveMonitor);
            List<FuzzyNodeCluster> silClusters = silRunFCM.run(this.network, saveMonitor, clusters);
            this.silhouetteResults[cEstimate] = SilhouetteCalculator.calculate(this.distanceDataMatrix.getMatrix2DArray(), clusters);
        }
    }

    private class RunCMeans
    implements Runnable {
        Matrix matrix;
        int[] clusters;
        int cEstimate;
        int nIterations;
        TaskMonitor saveMonitor = null;

        public RunCMeans(Matrix matrix, int[] clusters, int c, int nIterations, TaskMonitor saveMonitor) {
            this.matrix = matrix;
            this.clusters = clusters;
            this.cEstimate = c;
            this.nIterations = nIterations;
            this.saveMonitor = saveMonitor;
        }

        public void run() {
            int[] clusters = new int[this.matrix.nRows()];
            if (FCMCluster.this.cancelled()) {
                return;
            }
            if (this.saveMonitor != null) {
                this.saveMonitor.setStatusMessage("Getting silhouette with a c estimate of " + this.cEstimate);
            }
            try {
                ((FCMCluster)FCMCluster.this).silhouetteResults[this.cEstimate] = SilhouetteCalculator.calculate(this.matrix.getMatrix2DArray(), clusters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

