/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.clusterMaker2.internal.algorithms.networkClusterers.MCL;

import java.util.Vector;

public class Clustering {
    private double clusteringThresh;
    private Vector<Vector> clusters;
    public int numClusters = -1;

    public Clustering(int size, double clusteringThresh) {
        this.clusters = new Vector(size);
        for (int i = 0; i < size; ++i) {
            Vector<Integer> v = new Vector<Integer>();
            v.add(new Integer(i));
            this.clusters.add(v);
        }
        clusteringThresh = this.clusteringThresh;
    }

    private int getClusterIndex(int element) {
        for (int i = 0; i < this.clusters.size(); ++i) {
            Vector v = this.clusters.elementAt(i);
            if (!v.contains(new Integer(element))) continue;
            return i;
        }
        return -1;
    }

    private void combineClusters(int index1, int index2) {
        Vector cluster1 = this.clusters.elementAt(index1);
        Vector cluster2 = this.clusters.elementAt(index2);
        Vector cluster3 = new Vector(cluster1);
        cluster3.addAll(cluster2);
        this.clusters.add(cluster3);
        this.clusters.removeElementAt(index1);
        if (index2 < index1) {
            this.clusters.removeElementAt(index2);
        } else {
            this.clusters.removeElementAt(index2 - 1);
        }
    }

    private void clusterElements(int element1, int element2) {
        int index2;
        int index1 = this.getClusterIndex(element1);
        if (index1 != (index2 = this.getClusterIndex(element2)) && index1 != -1 && index2 != -1) {
            this.combineClusters(index1, index2);
        }
    }

    public double[] clusterMatrix(double[][] graph) {
        int i;
        double[] clusterArray = new double[graph.length];
        for (i = 0; i < graph.length; ++i) {
            for (int j = 0; j < graph.length; ++j) {
                if (i == j || !(graph[i][j] > this.clusteringThresh)) continue;
                this.clusterElements(i, j);
            }
        }
        this.numClusters = this.clusters.size();
        for (i = 0; i < this.clusters.size(); ++i) {
            Vector v = this.clusters.elementAt(i);
            for (int j = 0; j < v.size(); ++j) {
                int element = (Integer)v.elementAt(j);
                clusterArray[element] = i;
            }
        }
        return clusterArray;
    }
}

